/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.managers;

import com.artemis.BaseSystem;
import com.artemis.World;
import com.artemis.io.InputStreamHelper;
import com.artemis.io.SaveFileFormat;
import com.artemis.io.SerializationException;
import com.artemis.utils.IntBag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WorldSerializationManager
extends BaseSystem {
    private ArtemisSerializer<?> backend;
    public boolean alwaysLoadStreamMemory = true;
    private byte[] bytes;
    private ByteArrayOutputStream baos;

    protected void processSystem() {
    }

    public void setSerializer(ArtemisSerializer<?> backend) {
        this.backend = backend;
    }

    public <T extends ArtemisSerializer> T getSerializer() {
        return (T)this.backend;
    }

    public <T extends SaveFileFormat> T load(InputStream is, Class<T> format) {
        if (this.alwaysLoadStreamMemory || !InputStreamHelper.isMarkSupported((InputStream)is)) {
            try {
                int read;
                byte[] buf = this.byteBuffer();
                ByteArrayOutputStream baos = this.byteArrayOutputStream();
                while ((read = is.read(buf)) != -1) {
                    baos.write(buf, 0, read);
                }
                is = new ByteArrayInputStream(baos.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException("Error copying inputstream", e);
            }
        }
        return (T)this.backend.load(is, format);
    }

    public void save(OutputStream out, SaveFileFormat format) {
        if (this.backend == null) {
            throw new SerializationException("Missing ArtemisSerializer, see #setSerializer.");
        }
        this.world.inject((Object)format);
        this.backend.save(out, format);
    }

    private ByteArrayOutputStream byteArrayOutputStream() {
        if (this.baos == null) {
            this.baos = new ByteArrayOutputStream();
        } else {
            this.baos.reset();
        }
        return this.baos;
    }

    private byte[] byteBuffer() {
        if (this.bytes == null) {
            this.bytes = new byte[32768];
        }
        return this.bytes;
    }

    public static abstract class ArtemisSerializer<T> {
        protected World world;

        protected ArtemisSerializer(World world) {
            this.world = world;
        }

        protected final void save(OutputStream out, IntBag entities) {
            this.save(out, new SaveFileFormat(entities));
        }

        public abstract ArtemisSerializer register(Class<?> var1, T var2);

        protected abstract void save(OutputStream var1, SaveFileFormat var2);

        protected abstract <T extends SaveFileFormat> T load(InputStream var1, Class<T> var2);
    }
}

