/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.prefab;

import com.artemis.MundaneWireException;
import com.artemis.World;
import com.artemis.annotations.PrefabData;
import com.artemis.io.SaveFileFormat;
import com.artemis.managers.WorldSerializationManager;
import com.artemis.prefab.MissingPrefabDataException;
import com.artemis.prefab.PrefabReader;
import com.artemis.utils.reflect.ClassReflection;

public abstract class BasePrefab<DATA, SERIALIZER extends WorldSerializationManager.ArtemisSerializer> {
    protected final World world;
    private final PrefabReader<DATA> data;
    private WorldSerializationManager serializationManager;

    protected BasePrefab(World world, PrefabReader<DATA> data) {
        this.world = world;
        this.data = data;
        this.serializationManager = (WorldSerializationManager)world.getSystem(WorldSerializationManager.class);
        if (this.serializationManager == null) {
            throw new MundaneWireException(WorldSerializationManager.class);
        }
        world.inject((Object)this);
        data.initialize(this.getPrefabDataPath());
    }

    private String getPrefabDataPath() {
        PrefabData pd = (PrefabData)ClassReflection.getAnnotation(this.getClass(), PrefabData.class);
        if (pd != null) {
            return pd.value();
        }
        String annotation = PrefabData.class.getSimpleName();
        String message = this.getClass().getName() + " must be annotated with @" + annotation;
        throw new MissingPrefabDataException(message);
    }

    public final SaveFileFormat create() {
        Object serializer = this.serializationManager.getSerializer();
        return this.create(serializer, this.data.getData(), this.saveFileFormat());
    }

    protected abstract <T extends SaveFileFormat> T create(SERIALIZER var1, DATA var2, Class<T> var3);

    protected Class<SaveFileFormat> saveFileFormat() {
        return SaveFileFormat.class;
    }
}

