/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Archetype;
import com.artemis.Component;
import com.artemis.ComponentManager;
import com.artemis.ComponentMapper;
import com.artemis.ComponentType;
import com.artemis.ComponentTypeFactory;
import com.artemis.EntityTransmuter;
import com.artemis.World;
import com.artemis.utils.Bag;
import com.artemis.utils.BitVector;

public class ArchetypeBuilder {
    private final Bag<Class<? extends Component>> classes = new Bag();

    public ArchetypeBuilder(Archetype parent) {
        if (parent == null) {
            return;
        }
        parent.transmuter.getAdditions(this.classes);
    }

    public ArchetypeBuilder() {
        this(null);
    }

    public ArchetypeBuilder add(Class<? extends Component> type) {
        if (!this.classes.contains(type)) {
            this.classes.add(type);
        }
        return this;
    }

    public ArchetypeBuilder add(Class<? extends Component> ... types) {
        for (int i = 0; types.length > i; ++i) {
            Class<? extends Component> type = types[i];
            if (this.classes.contains(type)) continue;
            this.classes.add(type);
        }
        return this;
    }

    public ArchetypeBuilder remove(Class<? extends Component> type) {
        this.classes.remove(type);
        return this;
    }

    public ArchetypeBuilder remove(Class<? extends Component> ... types) {
        for (int i = 0; types.length > i; ++i) {
            this.classes.remove(types[i]);
        }
        return this;
    }

    public Archetype build(World world) {
        return this.build(world, null);
    }

    public Archetype build(World world, String name) {
        ComponentType[] types = this.resolveTypes(world);
        ComponentManager cm = world.getComponentManager();
        ComponentMapper[] mappers = new ComponentMapper[types.length];
        int s = mappers.length;
        for (int i = 0; s > i; ++i) {
            mappers[i] = cm.getMapper(types[i].getType());
        }
        int compositionId = cm.compositionIdentity(ArchetypeBuilder.bitset(types));
        if (name == null || name.isEmpty()) {
            name = String.valueOf(compositionId);
        }
        EntityTransmuter.TransmuteOperation operation = new EntityTransmuter.TransmuteOperation(compositionId, mappers, new ComponentMapper[0]);
        return new Archetype(operation, compositionId, name);
    }

    private static BitVector bitset(ComponentType[] types) {
        BitVector bs = new BitVector();
        for (int i = 0; types.length > i; ++i) {
            bs.set(types[i].getIndex());
        }
        return bs;
    }

    private ComponentType[] resolveTypes(World world) {
        ComponentTypeFactory tf = world.getComponentManager().typeFactory;
        ComponentType[] types = new ComponentType[this.classes.size()];
        int s = this.classes.size();
        for (int i = 0; s > i; ++i) {
            types[i] = tf.getTypeFor(this.classes.get(i));
        }
        return types;
    }
}

