/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.ComponentTypeFactory;
import com.artemis.Entity;
import com.artemis.World;
import com.artemis.utils.Bag;
import com.artemis.utils.BitVector;
import java.util.Collection;

public class Aspect {
    BitVector allSet = new BitVector();
    BitVector exclusionSet = new BitVector();
    BitVector oneSet = new BitVector();

    private Aspect() {
    }

    public BitVector getAllSet() {
        return this.allSet;
    }

    public BitVector getExclusionSet() {
        return this.exclusionSet;
    }

    public BitVector getOneSet() {
        return this.oneSet;
    }

    public boolean isInterested(Entity e) {
        return this.isInterested(e.getComponentBits());
    }

    public boolean isInterested(BitVector componentBits) {
        if (!this.allSet.isEmpty() && !componentBits.containsAll(this.allSet)) {
            return false;
        }
        if (!this.exclusionSet.isEmpty() && this.exclusionSet.intersects(componentBits)) {
            return false;
        }
        return this.oneSet.isEmpty() || this.oneSet.intersects(componentBits);
    }

    public static Builder all() {
        return new Builder().all(new Class[0]);
    }

    @SafeVarargs
    public static Builder all(Class<? extends Component> ... types) {
        return new Builder().all(types);
    }

    public static Builder all(Collection<Class<? extends Component>> types) {
        return new Builder().all(types);
    }

    @SafeVarargs
    public static Builder exclude(Class<? extends Component> ... types) {
        return new Builder().exclude(types);
    }

    public static Builder exclude(Collection<Class<? extends Component>> types) {
        return new Builder().exclude(types);
    }

    @SafeVarargs
    public static Builder one(Class<? extends Component> ... types) {
        return new Builder().one(types);
    }

    public static Builder one(Collection<Class<? extends Component>> types) {
        return new Builder().one(types);
    }

    public static class Builder {
        private final Bag<Class<? extends Component>> allTypes = new Bag();
        private final Bag<Class<? extends Component>> exclusionTypes = new Bag();
        private final Bag<Class<? extends Component>> oneTypes = new Bag();

        private Builder() {
        }

        @SafeVarargs
        public final Builder all(Class<? extends Component> ... types) {
            for (Class<? extends Component> t : types) {
                this.allTypes.add(t);
            }
            return this;
        }

        public Builder copy() {
            Builder b = new Builder();
            b.allTypes.addAll(this.allTypes);
            b.exclusionTypes.addAll(this.exclusionTypes);
            b.oneTypes.addAll(this.oneTypes);
            return b;
        }

        public Builder all(Collection<Class<? extends Component>> types) {
            for (Class<? extends Component> t : types) {
                this.allTypes.add(t);
            }
            return this;
        }

        @SafeVarargs
        public final Builder one(Class<? extends Component> ... types) {
            for (Class<? extends Component> t : types) {
                this.oneTypes.add(t);
            }
            return this;
        }

        public Builder one(Collection<Class<? extends Component>> types) {
            for (Class<? extends Component> t : types) {
                this.oneTypes.add(t);
            }
            return this;
        }

        @SafeVarargs
        public final Builder exclude(Class<? extends Component> ... types) {
            for (Class<? extends Component> t : types) {
                this.exclusionTypes.add(t);
            }
            return this;
        }

        public Builder exclude(Collection<Class<? extends Component>> types) {
            for (Class<? extends Component> t : types) {
                this.exclusionTypes.add(t);
            }
            return this;
        }

        public Aspect build(World world) {
            ComponentTypeFactory tf = world.getComponentManager().typeFactory;
            Aspect aspect = new Aspect();
            Builder.associate(tf, this.allTypes, aspect.allSet);
            Builder.associate(tf, this.exclusionTypes, aspect.exclusionSet);
            Builder.associate(tf, this.oneTypes, aspect.oneSet);
            return aspect;
        }

        private static void associate(ComponentTypeFactory tf, Bag<Class<? extends Component>> types, BitVector componentBits) {
            for (Class<? extends Component> t : types) {
                componentBits.set(tf.getIndexFor(t));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            if (!this.allTypes.equals(builder.allTypes)) {
                return false;
            }
            if (!this.exclusionTypes.equals(builder.exclusionTypes)) {
                return false;
            }
            return this.oneTypes.equals(builder.oneTypes);
        }

        public int hashCode() {
            int result = this.allTypes.hashCode();
            result = 31 * result + this.exclusionTypes.hashCode();
            result = 31 * result + this.oneTypes.hashCode();
            return result;
        }

        public String toString() {
            return "Aspect[all=" + this.append(this.allTypes) + ", one=" + this.append(this.oneTypes) + ", exclude=" + this.append(this.exclusionTypes) + ']';
        }

        private StringBuilder append(Bag<Class<? extends Component>> types) {
            StringBuilder sb = new StringBuilder();
            String delim = "";
            sb.append("(");
            for (Class<? extends Component> type : types) {
                sb.append(delim).append(type.getSimpleName());
                delim = ", ";
            }
            sb.append(")");
            return sb;
        }
    }
}

