/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Aspect;
import com.artemis.BaseSystem;
import com.artemis.EntitySubscription;
import com.artemis.World;
import com.artemis.annotations.SkipWire;
import com.artemis.utils.Bag;
import com.artemis.utils.BitVector;
import com.artemis.utils.ImmutableBag;
import com.artemis.utils.IntBag;
import java.util.HashMap;
import java.util.Map;

@SkipWire
public class AspectSubscriptionManager
extends BaseSystem {
    private final Map<Aspect.Builder, EntitySubscription> subscriptionMap;
    private final Bag<EntitySubscription> subscriptions = new Bag<EntitySubscription>(EntitySubscription.class);
    private final IntBag changed = new IntBag();
    private final IntBag deleted = new IntBag();

    protected AspectSubscriptionManager() {
        this.subscriptionMap = new HashMap<Aspect.Builder, EntitySubscription>();
    }

    @Override
    protected void processSystem() {
    }

    @Override
    protected void setWorld(World world) {
        super.setWorld(world);
        this.get(Aspect.all());
    }

    public EntitySubscription get(Aspect.Builder builder) {
        EntitySubscription subscription = this.subscriptionMap.get(builder);
        return subscription != null ? subscription : this.createSubscription(builder);
    }

    private EntitySubscription createSubscription(Aspect.Builder builder) {
        EntitySubscription entitySubscription = new EntitySubscription(this.world, builder);
        this.subscriptionMap.put(builder, entitySubscription);
        this.subscriptions.add(entitySubscription);
        this.world.getComponentManager().synchronize(entitySubscription);
        return entitySubscription;
    }

    void process(BitVector changedBits, BitVector deletedBits) {
        this.toEntityIntBags(changedBits, deletedBits);
        this.subscriptions.get(0).processAll(this.changed, this.deleted);
        int s = this.subscriptions.size();
        for (int i = 1; s > i; ++i) {
            this.subscriptions.get(i).process(this.changed, this.deleted);
        }
    }

    private void toEntityIntBags(BitVector changed, BitVector deleted) {
        changed.toIntBagIdCid(this.world.getComponentManager(), this.changed);
        deleted.toIntBag(this.deleted);
        changed.clear();
        deleted.clear();
    }

    void processComponentIdentity(int id, BitVector componentBits) {
        int s = this.subscriptions.size();
        for (int i = 0; s > i; ++i) {
            this.subscriptions.get(i).processComponentIdentity(id, componentBits);
        }
    }

    public ImmutableBag<EntitySubscription> getSubscriptions() {
        return this.subscriptions;
    }
}

