/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.ComponentType;
import com.artemis.Entity;
import com.artemis.World;

public abstract class BaseComponentMapper<A extends Component> {
    public final ComponentType type;

    protected BaseComponentMapper(ComponentType type) {
        this.type = type;
    }

    public static <T extends Component> BaseComponentMapper<T> getFor(Class<T> type, World world) {
        return world.getMapper(type);
    }

    public A get(Entity e) {
        return this.get(e.getId());
    }

    public abstract A get(int var1);

    public boolean has(Entity e) {
        return this.has(e.getId());
    }

    public abstract boolean has(int var1);

    public A create(Entity entity) {
        return this.create(entity.getId());
    }

    public abstract void remove(int var1);

    public void remove(Entity entity) {
        this.remove(entity.getId());
    }

    protected abstract void internalRemove(int var1);

    public abstract A create(int var1);

    public abstract A internalCreate(int var1);

    public A getSafe(int entityId, A fallback) {
        A c = this.get(entityId);
        return c != null ? c : fallback;
    }

    public A set(int entityId, boolean value) {
        if (value) {
            return this.create(entityId);
        }
        this.remove(entityId);
        return null;
    }

    public A set(Entity entity, boolean value) {
        return this.set(entity.getId(), value);
    }

    public A getSafe(Entity entity, A fallback) {
        return this.getSafe(entity.getId(), fallback);
    }

    public ComponentType getType() {
        return this.type;
    }

    public String toString() {
        return "ComponentMapper[" + this.type.getType().getSimpleName() + ']';
    }
}

