/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Aspect;
import com.artemis.AspectSubscriptionManager;
import com.artemis.BaseSystem;
import com.artemis.EntitySubscription;
import com.artemis.World;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.ReflectionUtil;
import com.artemis.utils.reflect.SystemMetadata;

public abstract class BaseEntitySystem
extends BaseSystem
implements EntitySubscription.SubscriptionListener {
    private final Aspect.Builder aspectConfiguration;
    protected EntitySubscription subscription;

    public BaseEntitySystem() {
        this(null);
    }

    public BaseEntitySystem(Aspect.Builder aspect) {
        if (aspect == null && (aspect = new SystemMetadata(this.getClass()).getAspect()) == null) {
            String error = "Aspect was null and no aspect annotations set on system (@All); to use systems which do not subscribe to entities, extend BaseSystem directly.";
            throw new NullPointerException(error);
        }
        this.aspectConfiguration = aspect;
    }

    @Override
    protected void setWorld(World world) {
        super.setWorld(world);
        this.subscription = this.getSubscription();
        if (ReflectionUtil.implementsAnyObserver(this)) {
            this.subscription.addSubscriptionListener(this);
        }
    }

    public EntitySubscription getSubscription() {
        AspectSubscriptionManager sm = this.world.getAspectSubscriptionManager();
        return sm.get(this.aspectConfiguration);
    }

    @Override
    public void inserted(IntBag entities) {
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            this.inserted(ids[i]);
        }
    }

    public IntBag getEntityIds() {
        return this.subscription.getEntities();
    }

    protected void inserted(int entityId) {
    }

    @Override
    public void removed(IntBag entities) {
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            this.removed(ids[i]);
        }
    }

    protected void removed(int entityId) {
    }
}

