/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.World;
import com.artemis.annotations.SkipWire;

public abstract class BaseSystem {
    @SkipWire
    protected World world;

    protected void begin() {
    }

    public final void process() {
        if (this.checkProcessing()) {
            this.begin();
            this.processSystem();
            this.end();
        }
    }

    protected abstract void processSystem();

    protected void end() {
    }

    protected boolean checkProcessing() {
        return true;
    }

    protected void initialize() {
    }

    public boolean isEnabled() {
        return this.world.invocationStrategy.isEnabled(this);
    }

    public void setEnabled(boolean enabled) {
        this.world.invocationStrategy.setEnabled(this, enabled);
    }

    protected void setWorld(World world) {
        this.world = world;
    }

    protected World getWorld() {
        return this.world;
    }

    protected void dispose() {
    }
}

