/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.AspectSubscriptionManager;
import com.artemis.ComponentRemover;
import com.artemis.EntityEdit;
import com.artemis.EntityManager;
import com.artemis.WildBag;
import com.artemis.World;
import com.artemis.utils.Bag;
import com.artemis.utils.BitVector;
import com.artemis.utils.IntBag;

final class BatchChangeProcessor {
    private final World world;
    private final AspectSubscriptionManager asm;
    final BitVector changed = new BitVector();
    final WildBag<ComponentRemover> purgatories = new WildBag<ComponentRemover>(ComponentRemover.class);
    private final BitVector deleted = new BitVector();
    private final BitVector pendingPurge = new BitVector();
    private final IntBag toPurge = new IntBag();
    private final Bag<EntityEdit> pool = new Bag();
    private final WildBag<EntityEdit> edited = new WildBag<EntityEdit>(EntityEdit.class);

    BatchChangeProcessor(World world) {
        this.world = world;
        this.asm = world.getAspectSubscriptionManager();
        EntityManager em = world.getEntityManager();
        em.registerEntityStore(this.changed);
        em.registerEntityStore(this.deleted);
        em.registerEntityStore(this.pendingPurge);
    }

    boolean isDeleted(int entityId) {
        return this.pendingPurge.unsafeGet(entityId);
    }

    void delete(int entityId) {
        this.deleted.unsafeSet(entityId);
        this.pendingPurge.unsafeSet(entityId);
        this.changed.unsafeClear(entityId);
    }

    EntityEdit obtainEditor(int entityId) {
        int size = this.edited.size();
        if (size != 0 && ((EntityEdit)this.edited.get(size - 1)).getEntityId() == entityId) {
            return (EntityEdit)this.edited.get(size - 1);
        }
        EntityEdit edit = this.entityEdit();
        this.edited.add(edit);
        edit.entityId = entityId;
        return edit;
    }

    private EntityEdit entityEdit() {
        if (this.pool.isEmpty()) {
            return new EntityEdit(this.world);
        }
        return this.pool.removeLast();
    }

    void update() {
        while (!this.changed.isEmpty() || !this.deleted.isEmpty()) {
            this.asm.process(this.changed, this.deleted);
            this.purgeComponents();
        }
        this.clean();
    }

    void purgeComponents() {
        int s = this.purgatories.size();
        for (int i = 0; s > i; ++i) {
            ((ComponentRemover)this.purgatories.get(i)).purge();
        }
        this.purgatories.setSize(0);
    }

    IntBag getPendingPurge() {
        this.pendingPurge.toIntBag(this.toPurge);
        this.pendingPurge.clear();
        return this.toPurge;
    }

    private boolean clean() {
        if (this.edited.isEmpty()) {
            return false;
        }
        E[] data = this.edited.getData();
        int s = this.edited.size();
        for (int i = 0; s > i; ++i) {
            EntityEdit edit = (EntityEdit)data[i];
            this.pool.add(edit);
        }
        this.edited.setSize(0);
        return true;
    }
}

