/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.BaseSystem;
import com.artemis.Component;
import com.artemis.ComponentMapper;
import com.artemis.ComponentType;
import com.artemis.ComponentTypeFactory;
import com.artemis.Entity;
import com.artemis.EntitySubscription;
import com.artemis.InvalidComponentException;
import com.artemis.annotations.SkipWire;
import com.artemis.utils.Bag;
import com.artemis.utils.BitVector;
import com.artemis.utils.ImmutableBag;
import com.artemis.utils.IntBag;
import com.artemis.utils.ShortBag;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.ReflectionException;

@SkipWire
public class ComponentManager
extends BaseSystem {
    static final int NO_COMPONENTS = 0;
    private Bag<ComponentMapper> mappers = new Bag<ComponentMapper>(ComponentMapper.class);
    private final ComponentIdentityResolver identityResolver = new ComponentIdentityResolver();
    final ShortBag entityToIdentity;
    protected final ComponentTypeFactory typeFactory;

    protected ComponentManager(int entityContainerSize) {
        this.entityToIdentity = new ShortBag(entityContainerSize);
        this.typeFactory = new ComponentTypeFactory(this, entityContainerSize);
    }

    @Override
    protected void processSystem() {
    }

    protected <T extends Component> T create(int owner, Class<T> componentClass) {
        return this.getMapper(componentClass).create(owner);
    }

    protected <T extends Component> ComponentMapper<T> getMapper(Class<T> mapper) {
        ComponentType type = this.typeFactory.getTypeFor(mapper);
        return this.mappers.get(type.getIndex());
    }

    void registerComponentType(ComponentType ct, int capacity) {
        int index = ct.getIndex();
        ComponentMapper<? extends Component> mapper = new ComponentMapper<Component>(ct.getType(), this.world);
        mapper.components.ensureCapacity(capacity);
        this.mappers.set(index, mapper);
    }

    static <T extends Component> T newInstance(Class<T> componentClass) {
        try {
            return (T)((Component)ClassReflection.newInstance(componentClass));
        }
        catch (ReflectionException e) {
            throw new InvalidComponentException(componentClass, "Unable to instantiate component.", e);
        }
    }

    void clean(IntBag pendingPurge) {
        int[] ids = pendingPurge.getData();
        int s = pendingPurge.size();
        for (int i = 0; s > i; ++i) {
            this.removeComponents(ids[i]);
        }
    }

    private void removeComponents(int entityId) {
        Bag<ComponentMapper> mappers = this.componentMappers(entityId);
        int s = mappers.size();
        for (int i = 0; s > i; ++i) {
            mappers.get(i).internalRemove(entityId);
        }
        this.setIdentity(entityId, 0);
    }

    protected Bag<Component> getComponentsByType(ComponentType type) {
        return this.mappers.get((int)type.getIndex()).components;
    }

    public ImmutableBag<ComponentType> getComponentTypes() {
        return this.typeFactory.types;
    }

    protected Component getComponent(int entityId, ComponentType type) {
        ComponentMapper mapper = this.mappers.get(type.getIndex());
        return mapper.get(entityId);
    }

    public Bag<Component> getComponentsFor(int entityId, Bag<Component> fillBag) {
        Bag<ComponentMapper> mappers = this.componentMappers(entityId);
        int s = mappers.size();
        for (int i = 0; s > i; ++i) {
            fillBag.add((Component)mappers.get(i).get(entityId));
        }
        return fillBag;
    }

    BitVector componentBits(int entityId) {
        short identityIndex = this.entityToIdentity.get(entityId);
        return this.identityResolver.compositionBits.get(identityIndex);
    }

    private Bag<ComponentMapper> componentMappers(int entityId) {
        short identityIndex = this.entityToIdentity.get(entityId);
        return this.identityResolver.compositionMappers.get(identityIndex);
    }

    public int compositionIdentity(BitVector componentBits) {
        int identity = this.identityResolver.getIdentity(componentBits);
        if (identity == -1) {
            identity = this.identityResolver.allocateIdentity(componentBits, this);
            this.world.getAspectSubscriptionManager().processComponentIdentity(identity, componentBits);
        }
        return identity;
    }

    public int getIdentity(int entityId) {
        return this.entityToIdentity.get(entityId);
    }

    void synchronize(EntitySubscription es) {
        Bag<BitVector> compositionBits = this.identityResolver.compositionBits;
        int s = compositionBits.size();
        for (int i = 1; s > i; ++i) {
            BitVector componentBits = compositionBits.get(i);
            es.processComponentIdentity(i, componentBits);
        }
        for (Entity e : this.world.getEntityManager().entities) {
            if (e == null) continue;
            es.check(e.id, this.getIdentity(e.id));
        }
        es.informEntityChanges();
        es.rebuildCompressedActives();
    }

    void setIdentity(int entityId, int compositionId) {
        this.entityToIdentity.unsafeSet(entityId, (short)compositionId);
    }

    public ComponentTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public void ensureCapacity(int newSize) {
        this.typeFactory.initialMapperCapacity = newSize;
        this.entityToIdentity.ensureCapacity(newSize);
        for (ComponentMapper mapper : this.mappers) {
            mapper.components.ensureCapacity(newSize);
        }
    }

    static final class ComponentIdentityResolver {
        final Bag<BitVector> compositionBits = new Bag<BitVector>(BitVector.class);
        final Bag<Bag<ComponentMapper>> compositionMappers;

        ComponentIdentityResolver() {
            this.compositionBits.add(new BitVector());
            this.compositionMappers = new Bag();
            this.compositionMappers.add(new Bag<ComponentMapper>(ComponentMapper.class));
        }

        int getIdentity(BitVector components) {
            BitVector[] bitsets = this.compositionBits.getData();
            int size = this.compositionBits.size();
            for (int i = 0; size > i; ++i) {
                if (!components.equals(bitsets[i])) continue;
                return i;
            }
            return -1;
        }

        int allocateIdentity(BitVector componentBits, ComponentManager cm) {
            Bag<ComponentMapper> mappers = new Bag<ComponentMapper>(ComponentMapper.class, componentBits.cardinality());
            ComponentTypeFactory tf = cm.getTypeFactory();
            int i = componentBits.nextSetBit(0);
            while (i >= 0) {
                mappers.add(cm.getMapper(tf.getTypeFor(i).getType()));
                i = componentBits.nextSetBit(i + 1);
            }
            this.compositionMappers.add(mappers);
            this.compositionBits.add(new BitVector(componentBits));
            return this.compositionBits.size() - 1;
        }
    }
}

