/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.BaseComponentMapper;
import com.artemis.Component;
import com.artemis.ComponentManager;
import com.artemis.ComponentPool;
import com.artemis.ComponentRemover;
import com.artemis.DelayedComponentRemover;
import com.artemis.EntityTransmuter;
import com.artemis.EntityTransmuterFactory;
import com.artemis.ImmediateComponentRemover;
import com.artemis.World;
import com.artemis.annotations.DelayedComponentRemoval;
import com.artemis.utils.Bag;
import com.artemis.utils.reflect.ClassReflection;

public class ComponentMapper<A extends Component>
extends BaseComponentMapper<A> {
    final Bag<A> components;
    private final EntityTransmuter createTransmuter;
    private final EntityTransmuter removeTransmuter;
    private final ComponentPool pool;
    private final ComponentRemover<A> purgatory;

    public ComponentMapper(Class<A> type, World world) {
        super(world.getComponentManager().typeFactory.getTypeFor(type));
        this.components = new Bag<A>(type);
        this.pool = this.type.isPooled ? new ComponentPool<A>(type) : null;
        this.purgatory = world.isAlwaysDelayComponentRemoval() || ClassReflection.isAnnotationPresent(type, DelayedComponentRemoval.class) ? new DelayedComponentRemover<A>(this.components, this.pool, world.batchProcessor) : new ImmediateComponentRemover<A>(this.components, this.pool);
        this.createTransmuter = new EntityTransmuterFactory(world).add(type).build();
        this.removeTransmuter = new EntityTransmuterFactory(world).remove(type).build();
    }

    @Override
    public A get(int entityId) {
        return (A)((Component)this.components.get(entityId));
    }

    @Override
    public boolean has(int entityId) {
        return this.get(entityId) != null && !this.purgatory.has(entityId);
    }

    @Override
    public void remove(int entityId) {
        A component = this.get(entityId);
        if (component != null) {
            this.removeTransmuter.transmuteNoOperation(entityId);
            this.purgatory.mark(entityId);
        }
    }

    @Override
    protected void internalRemove(int entityId) {
        A component = this.get(entityId);
        if (component != null) {
            this.purgatory.mark(entityId);
        }
    }

    @Override
    public A create(int entityId) {
        A component = this.get(entityId);
        if (component == null || this.purgatory.unmark(entityId)) {
            this.createTransmuter.transmuteNoOperation(entityId);
            component = this.createNew();
            this.components.unsafeSet(entityId, component);
        }
        return component;
    }

    @Override
    public A internalCreate(int entityId) {
        A component = this.get(entityId);
        if (component == null || this.purgatory.unmark(entityId)) {
            component = this.createNew();
            this.components.unsafeSet(entityId, component);
        }
        return component;
    }

    private A createNew() {
        return (A)(this.pool != null ? this.pool.obtain() : ComponentManager.newInstance(this.type.getType()));
    }
}

