/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.InvalidComponentException;
import com.artemis.PooledComponent;
import com.artemis.utils.Bag;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.ReflectionException;

public class ComponentPool<T extends PooledComponent> {
    private final Bag<T> cache;
    private Class<T> type;

    ComponentPool(Class<T> type) {
        this.type = type;
        this.cache = new Bag<T>(type);
    }

    <T extends PooledComponent> T obtain() {
        try {
            return (T)(this.cache.size() > 0 ? (PooledComponent)this.cache.removeLast() : (PooledComponent)ClassReflection.newInstance(this.type));
        }
        catch (ReflectionException e) {
            throw new InvalidComponentException(this.type, e.getMessage(), e);
        }
    }

    void free(T component) {
        ((PooledComponent)component).reset();
        this.cache.add(component);
    }
}

