/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.PooledComponent;
import com.artemis.utils.reflect.ClassReflection;

public class ComponentType {
    public final boolean isPooled;
    private final Class<? extends Component> type;
    private final int index;

    ComponentType(Class<? extends Component> type, int index) {
        this.index = index;
        this.type = type;
        this.isPooled = ClassReflection.isAssignableFrom(PooledComponent.class, type);
    }

    public int getIndex() {
        return this.index;
    }

    public Class<? extends Component> getType() {
        return this.type;
    }

    public String toString() {
        return "ComponentType[" + ClassReflection.getSimpleName(this.type) + "] (" + this.index + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentType that = (ComponentType)o;
        return this.index == that.index;
    }

    public int hashCode() {
        return this.index;
    }
}

