/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.ComponentManager;
import com.artemis.ComponentType;
import com.artemis.InvalidComponentException;
import com.artemis.utils.Bag;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Constructor;
import com.artemis.utils.reflect.ReflectionException;
import java.util.IdentityHashMap;

public class ComponentTypeFactory {
    private final IdentityHashMap<Class<? extends Component>, ComponentType> componentTypes = new IdentityHashMap();
    private final Bag<ComponentTypeListener> listeners = new Bag();
    final Bag<ComponentType> types = new Bag<ComponentType>(ComponentType.class);
    int initialMapperCapacity;
    private final ComponentManager cm;

    public ComponentTypeFactory(ComponentManager cm, int entityContainerSize) {
        this.cm = cm;
        this.initialMapperCapacity = entityContainerSize;
    }

    public ComponentType getTypeFor(Class<? extends Component> c) {
        ComponentType type = this.componentTypes.get(c);
        if (type == null) {
            type = this.createComponentType(c);
        }
        return type;
    }

    private ComponentType createComponentType(Class<? extends Component> c) {
        try {
            Constructor ctor = ClassReflection.getConstructor(c, new Class[0]);
            if ((ctor.getModifiers() & 1) == 0) {
                throw new InvalidComponentException(c, "missing public constructor");
            }
        }
        catch (ReflectionException e) {
            throw new InvalidComponentException(c, "missing public constructor", e);
        }
        ComponentType type = new ComponentType(c, this.types.size());
        this.componentTypes.put(c, type);
        this.types.add(type);
        this.cm.registerComponentType(type, this.initialMapperCapacity);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onCreated(type);
        }
        return type;
    }

    public ComponentType getTypeFor(int index) {
        return this.types.get(index);
    }

    public int getIndexFor(Class<? extends Component> c) {
        return this.getTypeFor(c).getIndex();
    }

    public void register(ComponentTypeListener listener) {
        this.listeners.add(listener);
        listener.initialize(this.types);
    }

    public static interface ComponentTypeListener {
        public void initialize(Bag<ComponentType> var1);

        public void onCreated(ComponentType var1);
    }
}

