/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

class ConfigurationElement<T>
implements Comparable<ConfigurationElement<T>> {
    public final int priority;
    public final Class<?> itemType;
    public T item;

    public ConfigurationElement(T item, int priority) {
        this.item = item;
        this.itemType = item.getClass();
        this.priority = priority;
    }

    @Override
    public int compareTo(ConfigurationElement<T> o) {
        return Integer.compare(o.priority, this.priority);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.item.equals(((ConfigurationElement)o).item);
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    public static <T> ConfigurationElement<T> of(T item) {
        return ConfigurationElement.of(item, 0);
    }

    public static <T> ConfigurationElement<T> of(T item, int priority) {
        return new ConfigurationElement<T>(item, priority);
    }
}

