/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.BatchChangeProcessor;
import com.artemis.Component;
import com.artemis.ComponentPool;
import com.artemis.ComponentRemover;
import com.artemis.PooledComponent;
import com.artemis.utils.Bag;
import com.artemis.utils.BitVector;

class DelayedComponentRemover<A extends Component>
extends ComponentRemover<A> {
    final BitVector idBits = new BitVector();
    final BatchChangeProcessor batchProcessor;

    DelayedComponentRemover(Bag<A> components, ComponentPool pool, BatchChangeProcessor batchProcessor) {
        super(components, pool);
        this.batchProcessor = batchProcessor;
    }

    @Override
    void mark(int entityId) {
        if (this.idBits.isEmpty()) {
            this.batchProcessor.purgatories.add(this);
        }
        this.idBits.set(entityId);
    }

    @Override
    boolean unmark(int entityId) {
        if (this.idBits.get(entityId)) {
            this.idBits.clear(entityId);
            if (this.pool != null) {
                this.pool.free((PooledComponent)this.components.get(entityId));
            }
            return true;
        }
        return false;
    }

    @Override
    void purge() {
        if (this.pool != null) {
            this.purgeWithPool();
        } else {
            this.purgeNoPool();
        }
        this.idBits.clear();
    }

    @Override
    boolean has(int entityId) {
        return this.idBits.get(entityId);
    }

    private void purgeWithPool() {
        int id = this.idBits.nextSetBit(0);
        while (id >= 0) {
            Component c = (Component)this.components.get(id);
            this.pool.free((PooledComponent)c);
            this.components.unsafeSet(id, null);
            id = this.idBits.nextSetBit(id + 1);
        }
    }

    private void purgeNoPool() {
        int id = this.idBits.nextSetBit(0);
        while (id >= 0) {
            this.components.unsafeSet(id, null);
            id = this.idBits.nextSetBit(id + 1);
        }
    }
}

