/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.ComponentType;
import com.artemis.ComponentTypeFactory;
import com.artemis.EntityEdit;
import com.artemis.World;
import com.artemis.utils.Bag;
import com.artemis.utils.BitVector;

public final class Entity {
    int id;
    private final World world;

    protected Entity(World world, int id) {
        this.world = world;
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    protected BitVector getComponentBits() {
        return this.world.getComponentManager().componentBits(this.id);
    }

    public EntityEdit edit() {
        return this.world.edit(this.id);
    }

    public String toString() {
        return "Entity[" + this.id + "]";
    }

    public boolean isActive() {
        return this.world.getEntityManager().isActive(this.id);
    }

    public Component getComponent(ComponentType type) {
        return this.world.getComponentManager().getComponent(this.id, type);
    }

    public <T extends Component> T getComponent(Class<T> type) {
        ComponentTypeFactory tf = this.world.getComponentManager().typeFactory;
        return (T)this.getComponent(tf.getTypeFor(type));
    }

    public Bag<Component> getComponents(Bag<Component> fillBag) {
        return this.world.getComponentManager().getComponentsFor(this.id, fillBag);
    }

    public void deleteFromWorld() {
        this.world.delete(this.id);
    }

    public World getWorld() {
        return this.world;
    }

    public int getCompositionId() {
        return this.world.getComponentManager().getIdentity(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity entity = (Entity)o;
        return this.id == entity.id;
    }

    public boolean equals(Entity o) {
        return o != null && o.id == this.id;
    }

    public int hashCode() {
        return this.id;
    }
}

