/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.ComponentManager;
import com.artemis.ComponentMapper;
import com.artemis.ComponentType;
import com.artemis.Entity;
import com.artemis.InvalidComponentException;
import com.artemis.World;

public final class EntityEdit {
    int entityId;
    private ComponentManager cm;

    EntityEdit(World world) {
        this.cm = world.getComponentManager();
    }

    public <T extends Component> T create(Class<T> componentKlazz) {
        return this.cm.getMapper(componentKlazz).create(this.entityId);
    }

    public EntityEdit add(Component component) {
        return this.add(component, this.cm.typeFactory.getTypeFor(component.getClass()));
    }

    public EntityEdit add(Component component, ComponentType type) {
        if (type.isPooled) {
            throw new InvalidComponentException(component.getClass(), "Use EntityEdit#create(Class<Component>) for adding non-basic component types");
        }
        ComponentMapper<? extends Component> mapper = this.cm.getMapper(type.getType());
        mapper.create(this.entityId);
        mapper.components.getData()[this.entityId] = component;
        return this;
    }

    public Entity getEntity() {
        return this.cm.world.getEntity(this.entityId);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public EntityEdit remove(Component component) {
        return this.remove(component.getClass());
    }

    public EntityEdit remove(ComponentType type) {
        this.cm.getMapper(type.getType()).remove(this.entityId);
        return this;
    }

    public EntityEdit remove(Class<? extends Component> type) {
        return this.remove(this.cm.typeFactory.getTypeFor(type));
    }

    public String toString() {
        return "EntityEdit[" + this.entityId + "]";
    }
}

