/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Aspect;
import com.artemis.BaseSystem;
import com.artemis.ComponentManager;
import com.artemis.Entity;
import com.artemis.annotations.SkipWire;
import com.artemis.utils.Bag;
import com.artemis.utils.BitVector;
import com.artemis.utils.IntBag;
import com.artemis.utils.IntDeque;

@SkipWire
public class EntityManager
extends BaseSystem {
    final Bag<Entity> entities;
    private final BitVector recycled = new BitVector();
    private final IntDeque limbo = new IntDeque();
    private int nextId;
    private Bag<BitVector> entityBitVectors = new Bag<BitVector>(BitVector.class);

    protected EntityManager(int initialContainerSize) {
        this.entities = new Bag(initialContainerSize);
        this.registerEntityStore(this.recycled);
    }

    @Override
    protected void processSystem() {
    }

    protected Entity createEntityInstance() {
        return this.obtain();
    }

    protected int create() {
        return this.obtain().id;
    }

    void clean(IntBag pendingDeletion) {
        int[] ids = pendingDeletion.getData();
        int s = pendingDeletion.size();
        for (int i = 0; s > i; ++i) {
            int id = ids[i];
            if (this.recycled.unsafeGet(id)) continue;
            this.free(id);
        }
    }

    public boolean isActive(int entityId) {
        return !this.recycled.unsafeGet(entityId);
    }

    public void registerEntityStore(BitVector bv) {
        bv.ensureCapacity(this.entities.getCapacity());
        this.entityBitVectors.add(bv);
    }

    protected Entity getEntity(int entityId) {
        return this.entities.get(entityId);
    }

    public boolean reset() {
        int count = this.world.getAspectSubscriptionManager().get(Aspect.all()).getActiveEntityIds().cardinality();
        if (count > 0) {
            return false;
        }
        this.limbo.clear();
        this.recycled.clear();
        this.entities.clear();
        this.nextId = 0;
        return true;
    }

    private Entity createEntity(int id) {
        Entity e = new Entity(this.world, id);
        if (e.id >= this.entities.getCapacity()) {
            this.growEntityStores();
        }
        this.entities.set(e.id, e);
        return e;
    }

    private void growEntityStores() {
        int newSize = 2 * this.entities.getCapacity();
        this.entities.ensureCapacity(newSize);
        ComponentManager cm = this.world.getComponentManager();
        cm.ensureCapacity(newSize);
        int s = this.entityBitVectors.size();
        for (int i = 0; s > i; ++i) {
            this.entityBitVectors.get(i).ensureCapacity(newSize);
        }
    }

    private Entity obtain() {
        if (this.limbo.isEmpty()) {
            return this.createEntity(this.nextId++);
        }
        int id = this.limbo.popFirst();
        this.recycled.unsafeClear(id);
        return this.entities.get(id);
    }

    private void free(int entityId) {
        this.limbo.add(entityId);
        this.recycled.unsafeSet(entityId);
    }
}

