/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Aspect;
import com.artemis.EntityManager;
import com.artemis.World;
import com.artemis.utils.Bag;
import com.artemis.utils.BitVector;
import com.artemis.utils.IntBag;

public class EntitySubscription {
    final SubscriptionExtra extra;
    private final IntBag entities;
    private final BitVector activeEntityIds;
    private final BitVector insertedIds;
    private final BitVector removedIds;
    final BitVector aspectCache = new BitVector();

    EntitySubscription(World world, Aspect.Builder builder) {
        this.extra = new SubscriptionExtra(builder.build(world), builder);
        this.activeEntityIds = new BitVector();
        this.entities = new IntBag();
        this.insertedIds = new BitVector();
        this.removedIds = new BitVector();
        EntityManager em = world.getEntityManager();
        em.registerEntityStore(this.activeEntityIds);
        em.registerEntityStore(this.insertedIds);
        em.registerEntityStore(this.removedIds);
    }

    public IntBag getEntities() {
        if (this.entities.isEmpty() && !this.activeEntityIds.isEmpty()) {
            this.rebuildCompressedActives();
        }
        return this.entities;
    }

    public BitVector getActiveEntityIds() {
        return this.activeEntityIds;
    }

    public Aspect getAspect() {
        return this.extra.aspect;
    }

    public Aspect.Builder getAspectBuilder() {
        return this.extra.aspectReflection;
    }

    void processComponentIdentity(int id, BitVector componentBits) {
        this.aspectCache.ensureCapacity(id);
        this.aspectCache.set(id, this.extra.aspect.isInterested(componentBits));
    }

    void rebuildCompressedActives() {
        this.activeEntityIds.toIntBag(this.entities);
    }

    final void check(int id, int cid) {
        boolean interested = this.aspectCache.unsafeGet(cid);
        boolean contains = this.activeEntityIds.unsafeGet(id);
        if (interested && !contains) {
            this.insert(id);
        } else if (!interested && contains) {
            this.remove(id);
        }
    }

    private void remove(int entityId) {
        this.activeEntityIds.unsafeClear(entityId);
        this.removedIds.unsafeSet(entityId);
    }

    private void insert(int entityId) {
        this.activeEntityIds.unsafeSet(entityId);
        this.insertedIds.unsafeSet(entityId);
    }

    void process(IntBag changed, IntBag deleted) {
        this.deleted(deleted);
        this.changed(changed);
        this.informEntityChanges();
    }

    void processAll(IntBag changed, IntBag deleted) {
        this.deletedAll(deleted);
        this.changed(changed);
        this.informEntityChanges();
    }

    void informEntityChanges() {
        if (this.insertedIds.isEmpty() && this.removedIds.isEmpty()) {
            return;
        }
        this.transferBitsToInts(this.extra.inserted, this.extra.removed);
        this.extra.informEntityChanges();
        this.entities.setSize(0);
    }

    private void transferBitsToInts(IntBag inserted, IntBag removed) {
        this.insertedIds.toIntBag(inserted);
        this.removedIds.toIntBag(removed);
        this.insertedIds.clear();
        this.removedIds.clear();
    }

    private void changed(IntBag entitiesWithCompositions) {
        int[] ids = entitiesWithCompositions.getData();
        int s = entitiesWithCompositions.size();
        for (int i = 0; s > i; i += 2) {
            int id = ids[i];
            boolean interested = this.aspectCache.unsafeGet(ids[i + 1]);
            boolean contains = this.activeEntityIds.unsafeGet(id);
            if (interested && !contains) {
                this.insert(id);
                continue;
            }
            if (interested || !contains) continue;
            this.remove(id);
        }
    }

    private void deleted(IntBag entities) {
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            int id = ids[i];
            if (!this.activeEntityIds.unsafeGet(id)) continue;
            this.remove(id);
        }
    }

    private void deletedAll(IntBag entities) {
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            int id = ids[i];
            this.activeEntityIds.unsafeClear(id);
            this.removedIds.unsafeSet(id);
        }
    }

    public void addSubscriptionListener(SubscriptionListener listener) {
        this.extra.listeners.add(listener);
    }

    public void removeSubscriptionListener(SubscriptionListener listener) {
        this.extra.listeners.remove(listener);
    }

    public String toString() {
        return "EntitySubscription[" + this.getAspectBuilder() + "]";
    }

    public static class SubscriptionExtra {
        final IntBag inserted = new IntBag();
        final IntBag removed = new IntBag();
        final Aspect aspect;
        final Aspect.Builder aspectReflection;
        final Bag<SubscriptionListener> listeners = new Bag();

        public SubscriptionExtra(Aspect aspect, Aspect.Builder aspectReflection) {
            this.aspect = aspect;
            this.aspectReflection = aspectReflection;
        }

        void informEntityChanges() {
            this.informListeners();
            this.removed.setSize(0);
            this.inserted.setSize(0);
        }

        private void informListeners() {
            int s = this.listeners.size();
            for (int i = 0; s > i; ++i) {
                SubscriptionListener listener = this.listeners.get(i);
                if (this.removed.size() > 0) {
                    listener.removed(this.removed);
                }
                if (this.inserted.size() <= 0) continue;
                listener.inserted(this.inserted);
            }
        }
    }

    public static interface SubscriptionListener {
        public void inserted(IntBag var1);

        public void removed(IntBag var1);
    }
}

