/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Aspect;
import com.artemis.BaseEntitySystem;
import com.artemis.Entity;
import com.artemis.EntitySubscription;
import com.artemis.WildBag;
import com.artemis.World;
import com.artemis.utils.Bag;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.ReflectionUtil;
import java.util.Arrays;

public abstract class EntitySystem
extends BaseEntitySystem
implements EntitySubscription.SubscriptionListener {
    static final int FLAG_INSERTED = 1;
    static final int FLAG_REMOVED = 2;
    private boolean shouldSyncEntities;
    private WildBag<Entity> entities = new WildBag<Entity>(Entity.class);
    private int methodFlags;

    public EntitySystem(Aspect.Builder aspect) {
        super(aspect);
    }

    public EntitySystem() {
    }

    @Override
    protected void setWorld(World world) {
        super.setWorld(world);
        if (ReflectionUtil.implementsObserver(this, "inserted")) {
            this.methodFlags |= 1;
        }
        if (ReflectionUtil.implementsObserver(this, "removed")) {
            this.methodFlags |= 2;
        }
    }

    @Override
    public final void inserted(IntBag entities) {
        this.shouldSyncEntities = true;
        if ((this.methodFlags & 1) > 0) {
            super.inserted(entities);
        }
    }

    @Override
    protected final void inserted(int entityId) {
        this.inserted(this.world.getEntity(entityId));
    }

    @Override
    public final void removed(IntBag entities) {
        this.shouldSyncEntities = true;
        if ((this.methodFlags & 2) > 0) {
            super.removed(entities);
        }
    }

    @Override
    protected final void removed(int entityId) {
        this.removed(this.world.getEntity(entityId));
    }

    public void inserted(Entity e) {
        throw new RuntimeException("everything changes");
    }

    public void removed(Entity e) {
        throw new RuntimeException("everything breaks");
    }

    public Bag<Entity> getEntities() {
        if (this.shouldSyncEntities) {
            int oldSize = this.entities.size();
            this.entities.setSize(0);
            IntBag entityIds = this.subscription.getEntities();
            int[] ids = entityIds.getData();
            for (int i = 0; i < entityIds.size(); ++i) {
                this.entities.add(this.world.getEntity(ids[i]));
            }
            if (oldSize > this.entities.size()) {
                Arrays.fill(this.entities.getData(), this.entities.size(), oldSize, null);
            }
            this.shouldSyncEntities = false;
        }
        return this.entities;
    }
}

