/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Aspect;
import com.artemis.BatchChangeProcessor;
import com.artemis.Component;
import com.artemis.ComponentManager;
import com.artemis.ComponentMapper;
import com.artemis.ComponentTypeFactory;
import com.artemis.Entity;
import com.artemis.EntityManager;
import com.artemis.World;
import com.artemis.utils.Bag;
import com.artemis.utils.BitVector;
import com.artemis.utils.ShortBag;

public final class EntityTransmuter {
    private final Factory factory;
    private final EntityManager em;
    private final BatchChangeProcessor batchProcessor;
    private final Bag<TransmuteOperation> operations;
    private final ShortBag entityToIdentity;

    public EntityTransmuter(World world, Aspect.Builder aspect) {
        this(world, world.getAspectSubscriptionManager().get(aspect).getAspect());
    }

    EntityTransmuter(World world, Aspect aspect) {
        this(world, new BitVector(aspect.allSet), new BitVector(aspect.exclusionSet));
    }

    EntityTransmuter(World world, BitVector additions, BitVector removals) {
        this.em = world.getEntityManager();
        this.entityToIdentity = world.getComponentManager().entityToIdentity;
        this.batchProcessor = world.batchProcessor;
        this.operations = new Bag<TransmuteOperation>(TransmuteOperation.class);
        this.factory = new Factory(world, additions, removals);
    }

    public void transmute(int entityId) {
        if (!this.isValid(entityId)) {
            return;
        }
        TransmuteOperation operation = this.getOperation(entityId);
        operation.perform(entityId);
        this.entityToIdentity.unsafeSet(entityId, operation.compositionId);
    }

    void transmuteNoOperation(int entityId) {
        if (!this.isValid(entityId)) {
            return;
        }
        TransmuteOperation operation = this.getOperation(entityId);
        this.entityToIdentity.unsafeSet(entityId, operation.compositionId);
    }

    private boolean isValid(int entityId) {
        if (!this.em.isActive(entityId)) {
            throw new RuntimeException("Issued transmute on deleted " + entityId);
        }
        if (this.batchProcessor.isDeleted(entityId)) {
            return false;
        }
        this.batchProcessor.changed.unsafeSet(entityId);
        return true;
    }

    public void transmute(Entity e) {
        this.transmute(e.id);
    }

    TransmuteOperation getOperation(int entityId) {
        return this.operation(entityId, this.entityToIdentity.get(entityId));
    }

    private TransmuteOperation operation(int entityId, int compositionId) {
        TransmuteOperation operation = this.operations.safeGet(compositionId);
        if (operation == null) {
            operation = this.factory.createOperation(entityId);
            this.operations.set(compositionId, operation);
        }
        return operation;
    }

    public String toString() {
        return "EntityTransmuter(add=" + this.factory.additions + " remove=" + this.factory.removals + ")";
    }

    static class TransmuteOperation {
        private final ComponentMapper[] additions;
        private final ComponentMapper[] removals;
        public final short compositionId;

        public TransmuteOperation(int compositionId, ComponentMapper[] additions, ComponentMapper[] removals) {
            this.compositionId = (short)compositionId;
            this.additions = additions;
            this.removals = removals;
        }

        public TransmuteOperation(int compositionId, Bag<ComponentMapper> additions, Bag<ComponentMapper> removals) {
            int i;
            this.compositionId = (short)compositionId;
            this.additions = new ComponentMapper[additions.size()];
            this.removals = new ComponentMapper[removals.size()];
            int s = additions.size();
            for (i = 0; s > i; ++i) {
                this.additions[i] = additions.get(i);
            }
            s = removals.size();
            for (i = 0; s > i; ++i) {
                this.removals[i] = removals.get(i);
            }
        }

        public void perform(int entityId) {
            int i;
            int s = this.additions.length;
            for (i = 0; s > i; ++i) {
                this.additions[i].internalCreate(entityId);
            }
            s = this.removals.length;
            for (i = 0; s > i; ++i) {
                this.removals[i].internalRemove(entityId);
            }
        }

        Bag<Class<? extends Component>> getAdditions(Bag<Class<? extends Component>> out) {
            int s = this.additions.length;
            for (int i = 0; s > i; ++i) {
                out.add(this.additions[i].getType().getType());
            }
            return out;
        }

        public String toString() {
            String delim;
            StringBuilder sb = new StringBuilder();
            sb.append("TransmuteOperation(");
            if (this.additions.length > 0) {
                sb.append("add={");
                delim = "";
                for (ComponentMapper mapper : this.additions) {
                    sb.append(delim).append(mapper.getType().getType().getSimpleName());
                    delim = ", ";
                }
                sb.append("}");
            }
            if (this.removals.length > 0) {
                if (this.additions.length > 0) {
                    sb.append(" ");
                }
                sb.append("remove={");
                delim = "";
                for (ComponentMapper mapper : this.removals) {
                    sb.append(delim).append(mapper.getType().getType().getSimpleName());
                    delim = ", ";
                }
                sb.append("}");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    static class Factory {
        private final ComponentManager cm;
        private final BitVector additions;
        private final BitVector removals;
        private final BitVector bs;

        Factory(World world, BitVector additions, BitVector removals) {
            this.cm = world.getComponentManager();
            this.additions = additions;
            this.removals = removals;
            this.bs = new BitVector();
        }

        TransmuteOperation createOperation(int entityId) {
            BitVector componentBits = this.cm.componentBits(entityId);
            this.bs.clear();
            this.bs.or(componentBits);
            this.bs.or(this.additions);
            this.bs.andNot(this.removals);
            int compositionId = this.cm.compositionIdentity(this.bs);
            return new TransmuteOperation(compositionId, this.getAdditions(componentBits), this.getRemovals(componentBits));
        }

        private Bag<ComponentMapper> getAdditions(BitVector origin) {
            ComponentTypeFactory tf = this.cm.typeFactory;
            Bag<ComponentMapper> types = new Bag<ComponentMapper>(ComponentMapper.class);
            int i = this.additions.nextSetBit(0);
            while (i >= 0) {
                if (!origin.get(i)) {
                    types.add(this.cm.getMapper(tf.getTypeFor(i).getType()));
                }
                i = this.additions.nextSetBit(i + 1);
            }
            return types;
        }

        private Bag<ComponentMapper> getRemovals(BitVector origin) {
            ComponentTypeFactory tf = this.cm.typeFactory;
            Bag<ComponentMapper> types = new Bag<ComponentMapper>(ComponentMapper.class);
            int i = this.removals.nextSetBit(0);
            while (i >= 0) {
                if (origin.get(i)) {
                    types.add(this.cm.getMapper(tf.getTypeFor(i).getType()));
                }
                i = this.removals.nextSetBit(i + 1);
            }
            return types;
        }
    }
}

