/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.ComponentPool;
import com.artemis.ComponentRemover;
import com.artemis.PooledComponent;
import com.artemis.utils.Bag;

public class ImmediateComponentRemover<A extends Component>
extends ComponentRemover<A> {
    public ImmediateComponentRemover(Bag<A> components, ComponentPool pool) {
        super(components, pool);
    }

    @Override
    void mark(int entityId) {
        PooledComponent c;
        if (this.pool != null && (c = (PooledComponent)this.components.get(entityId)) != null) {
            this.pool.free(c);
        }
        this.components.unsafeSet(entityId, null);
    }

    @Override
    boolean unmark(int entityId) {
        return false;
    }

    @Override
    void purge() {
    }

    @Override
    boolean has(int entityId) {
        return false;
    }
}

