/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Aspect;
import com.artemis.BaseSystem;
import com.artemis.Entity;
import com.artemis.EntitySubscription;
import com.artemis.World;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.ReflectionUtil;

public abstract class Manager
extends BaseSystem {
    private int methodFlags;

    public void added(Entity e) {
        throw new RuntimeException("I shouldn't be here...");
    }

    public void deleted(Entity e) {
        throw new RuntimeException("... if it weren't for the tests.");
    }

    @Override
    protected void setWorld(World world) {
        super.setWorld(world);
        if (ReflectionUtil.implementsObserver(this, "added")) {
            this.methodFlags |= 1;
        }
        if (ReflectionUtil.implementsObserver(this, "deleted")) {
            this.methodFlags |= 2;
        }
    }

    protected void registerManager() {
        this.world.getAspectSubscriptionManager().get(Aspect.all()).addSubscriptionListener(new EntitySubscription.SubscriptionListener(){

            @Override
            public void inserted(IntBag entities) {
                Manager.this.added(entities);
            }

            @Override
            public void removed(IntBag entities) {
                Manager.this.deleted(entities);
            }
        });
    }

    private void added(IntBag entities) {
        if ((this.methodFlags & 1) == 0) {
            return;
        }
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            this.added(this.world.getEntity(ids[i]));
        }
    }

    private void deleted(IntBag entities) {
        if ((this.methodFlags & 2) == 0) {
            return;
        }
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            this.deleted(this.world.getEntity(ids[i]));
        }
    }

    @Override
    protected final void processSystem() {
    }
}

