/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.BaseSystem;
import com.artemis.World;
import com.artemis.utils.Bag;
import com.artemis.utils.BitVector;
import com.artemis.utils.ImmutableBag;

public abstract class SystemInvocationStrategy {
    protected World world;
    protected final BitVector disabled = new BitVector();
    protected Bag<BaseSystem> systems;

    protected final void setWorld(World world) {
        this.world = world;
    }

    protected void setSystems(Bag<BaseSystem> systems) {
        this.systems = systems;
    }

    protected void initialize() {
    }

    protected final void updateEntityStates() {
        this.world.batchProcessor.update();
    }

    @Deprecated
    protected final void process(Bag<BaseSystem> systems) {
        throw new RuntimeException("wrong process method");
    }

    protected abstract void process();

    public boolean isEnabled(BaseSystem system) {
        Class<?> target = system.getClass();
        ImmutableBag<BaseSystem> systems = this.world.getSystems();
        for (int i = 0; i < systems.size(); ++i) {
            if (target != systems.get(i).getClass()) continue;
            return !this.disabled.get(i);
        }
        throw new RuntimeException("huh?");
    }

    public void setEnabled(BaseSystem system, boolean value) {
        Class<?> target = system.getClass();
        ImmutableBag<BaseSystem> systems = this.world.getSystems();
        for (int i = 0; i < systems.size(); ++i) {
            if (target != systems.get(i).getClass()) continue;
            this.disabled.set(i, !value);
        }
    }
}

