/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Archetype;
import com.artemis.ArtemisMultiException;
import com.artemis.AspectSubscriptionManager;
import com.artemis.BaseSystem;
import com.artemis.BatchChangeProcessor;
import com.artemis.Component;
import com.artemis.ComponentManager;
import com.artemis.ComponentMapper;
import com.artemis.Entity;
import com.artemis.EntityEdit;
import com.artemis.EntityManager;
import com.artemis.MundaneWireException;
import com.artemis.SystemInvocationStrategy;
import com.artemis.WorldConfiguration;
import com.artemis.injection.CachedInjector;
import com.artemis.injection.Injector;
import com.artemis.utils.Bag;
import com.artemis.utils.ImmutableBag;
import com.artemis.utils.IntBag;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;

public class World {
    private final EntityManager em;
    private final ComponentManager cm;
    final BatchChangeProcessor batchProcessor;
    final Bag<BaseSystem> systemsBag;
    final AspectSubscriptionManager asm;
    SystemInvocationStrategy invocationStrategy;
    final WorldSegment partition;
    public float delta;
    final boolean alwaysDelayComponentRemoval;

    public World() {
        this(new WorldConfiguration());
    }

    public World(WorldConfiguration configuration) {
        this.partition = new WorldSegment(configuration);
        this.systemsBag = configuration.systems;
        ComponentManager lcm = (ComponentManager)this.systemsBag.get(0);
        EntityManager lem = (EntityManager)this.systemsBag.get(1);
        AspectSubscriptionManager lasm = (AspectSubscriptionManager)this.systemsBag.get(2);
        this.cm = lcm == null ? new ComponentManager(configuration.expectedEntityCount()) : lcm;
        this.em = lem == null ? new EntityManager(configuration.expectedEntityCount()) : lem;
        this.asm = lasm == null ? new AspectSubscriptionManager() : lasm;
        this.batchProcessor = new BatchChangeProcessor(this);
        this.alwaysDelayComponentRemoval = configuration.isAlwaysDelayComponentRemoval();
        configuration.initialize(this, this.partition.injector, this.asm);
    }

    public void inject(Object target) {
        this.inject(target, true);
    }

    public void inject(Object target, boolean failIfNotInjectable) {
        boolean injectable = this.partition.injector.isInjectable(target);
        if (!injectable && failIfNotInjectable) {
            throw new MundaneWireException("Attempted injection on " + target.getClass().getName() + ", which is annotated with @SkipWire");
        }
        if (injectable) {
            this.partition.injector.inject(target);
        }
    }

    public <T> T getRegistered(String name) {
        return this.partition.injector.getRegistered(name);
    }

    public <T> T getRegistered(Class<T> type) {
        return this.partition.injector.getRegistered(type);
    }

    public void dispose() {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (BaseSystem system : this.systemsBag) {
            try {
                system.dispose();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (exceptions.size() > 0) {
            throw new ArtemisMultiException(exceptions);
        }
    }

    public EntityEdit edit(int entityId) {
        if (!this.em.isActive(entityId)) {
            throw new RuntimeException("Issued edit on deleted " + entityId);
        }
        return this.batchProcessor.obtainEditor(entityId);
    }

    public int compositionId(int entityId) {
        return this.cm.getIdentity(entityId);
    }

    public EntityManager getEntityManager() {
        return this.em;
    }

    public ComponentManager getComponentManager() {
        return this.cm;
    }

    public AspectSubscriptionManager getAspectSubscriptionManager() {
        return this.asm;
    }

    public float getDelta() {
        return this.delta;
    }

    public void setDelta(float delta) {
        this.delta = delta;
    }

    public void deleteEntity(Entity e) {
        this.delete(e.id);
    }

    public void delete(int entityId) {
        this.batchProcessor.delete(entityId);
    }

    public Entity createEntity() {
        Entity e = this.em.createEntityInstance();
        this.batchProcessor.changed.unsafeSet(e.getId());
        return e;
    }

    public int create() {
        int entityId = this.em.create();
        this.batchProcessor.changed.unsafeSet(entityId);
        return entityId;
    }

    public Entity createEntity(Archetype archetype) {
        Entity e = this.em.createEntityInstance();
        int id = e.getId();
        archetype.transmuter.perform(id);
        this.cm.setIdentity(e.id, archetype.compositionId);
        this.batchProcessor.changed.unsafeSet(id);
        return e;
    }

    public int create(Archetype archetype) {
        int entityId = this.em.create();
        archetype.transmuter.perform(entityId);
        this.cm.setIdentity(entityId, archetype.compositionId);
        this.batchProcessor.changed.unsafeSet(entityId);
        return entityId;
    }

    public Entity getEntity(int entityId) {
        return this.em.getEntity(entityId);
    }

    public ImmutableBag<BaseSystem> getSystems() {
        return this.systemsBag;
    }

    public <T extends BaseSystem> T getSystem(Class<T> type) {
        return (T)this.partition.systems.get(type);
    }

    protected void setInvocationStrategy(SystemInvocationStrategy invocationStrategy) {
        this.invocationStrategy = invocationStrategy;
        invocationStrategy.setWorld(this);
        invocationStrategy.setSystems(this.systemsBag);
        invocationStrategy.initialize();
    }

    public void process() {
        this.invocationStrategy.process();
        IntBag pendingPurge = this.batchProcessor.getPendingPurge();
        if (!pendingPurge.isEmpty()) {
            this.cm.clean(pendingPurge);
            this.em.clean(pendingPurge);
            this.batchProcessor.purgeComponents();
        }
    }

    public <T extends Component> ComponentMapper<T> getMapper(Class<T> type) {
        return this.cm.getMapper(type);
    }

    public Injector getInjector() {
        return this.partition.injector;
    }

    public <T extends SystemInvocationStrategy> T getInvocationStrategy() {
        return (T)this.invocationStrategy;
    }

    public boolean isAlwaysDelayComponentRemoval() {
        return this.alwaysDelayComponentRemoval;
    }

    static class WorldSegment {
        final Map<Class<?>, BaseSystem> systems = new IdentityHashMap();
        final Injector injector;

        WorldSegment(WorldConfiguration configuration) {
            this.injector = configuration.injector != null ? configuration.injector : new CachedInjector();
        }
    }
}

