/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.AspectSubscriptionManager;
import com.artemis.BaseSystem;
import com.artemis.InvocationStrategy;
import com.artemis.Manager;
import com.artemis.SystemInvocationStrategy;
import com.artemis.World;
import com.artemis.injection.Injector;
import com.artemis.utils.Bag;
import com.artemis.utils.BitVector;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.ReflectionException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class WorldConfiguration {
    public static final int COMPONENT_MANAGER_IDX = 0;
    public static final int ENTITY_MANAGER_IDX = 1;
    public static final int ASPECT_SUBSCRIPTION_MANAGER_IDX = 2;
    final Bag<BaseSystem> systems = new Bag<BaseSystem>(BaseSystem.class);
    protected int expectedEntityCount = 128;
    protected Map<String, Object> injectables = new HashMap<String, Object>();
    protected Injector injector;
    protected SystemInvocationStrategy invocationStrategy;
    private boolean alwaysDelayComponentRemoval = false;
    private Set<Class<? extends BaseSystem>> registered = new HashSet<Class<? extends BaseSystem>>();

    public WorldConfiguration() {
        this.systems.add(null);
        this.systems.add(null);
        this.systems.add(null);
    }

    public int expectedEntityCount() {
        return this.expectedEntityCount;
    }

    public WorldConfiguration expectedEntityCount(int expectedEntityCount) {
        this.expectedEntityCount = expectedEntityCount;
        return this;
    }

    public WorldConfiguration setInjector(Injector injector) {
        if (injector == null) {
            throw new NullPointerException("Injector must not be null");
        }
        this.injector = injector;
        return this;
    }

    public WorldConfiguration setInvocationStrategy(SystemInvocationStrategy invocationStrategy) {
        if (invocationStrategy == null) {
            throw new NullPointerException();
        }
        this.invocationStrategy = invocationStrategy;
        return this;
    }

    public WorldConfiguration register(Object o) {
        return this.register(o.getClass().getName(), o);
    }

    public WorldConfiguration register(String name, Object o) {
        this.injectables.put(name, o);
        return this;
    }

    public WorldConfiguration setSystem(Class<? extends BaseSystem> system) {
        try {
            return this.setSystem(ClassReflection.newInstance(system));
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends BaseSystem> WorldConfiguration setSystem(T system) {
        this.systems.add(system);
        if (!this.registered.add(system.getClass())) {
            String name = system.getClass().getSimpleName();
            throw new RuntimeException(name + " already added to " + this.getClass().getSimpleName());
        }
        return this;
    }

    void initialize(World world, Injector injector, AspectSubscriptionManager asm) {
        if (this.invocationStrategy == null) {
            this.invocationStrategy = new InvocationStrategy();
        }
        this.invocationStrategy.setWorld(world);
        world.invocationStrategy = this.invocationStrategy;
        this.systems.set(0, world.getComponentManager());
        this.systems.set(1, world.getEntityManager());
        this.systems.set(2, asm);
        for (BaseSystem system : this.systems) {
            world.partition.systems.put(system.getClass(), system);
            system.setWorld(world);
            if (!ClassReflection.isInstance(Manager.class, system)) continue;
            ((Manager)system).registerManager();
        }
        injector.initialize(world, this.injectables);
        this.initializeSystems(injector);
        asm.processComponentIdentity(0, new BitVector());
        this.invocationStrategy.setSystems(this.systems);
        this.invocationStrategy.initialize();
    }

    private void initializeSystems(Injector injector) {
        BaseSystem system;
        int i;
        int s = this.systems.size();
        for (i = 0; i < s; ++i) {
            system = this.systems.get(i);
            injector.inject(system);
        }
        s = this.systems.size();
        for (i = 0; i < s; ++i) {
            system = this.systems.get(i);
            system.initialize();
        }
    }

    public boolean isAlwaysDelayComponentRemoval() {
        return this.alwaysDelayComponentRemoval;
    }

    public void setAlwaysDelayComponentRemoval(boolean value) {
        this.alwaysDelayComponentRemoval = value;
    }
}

