/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.ArtemisPlugin;
import com.artemis.BaseSystem;
import com.artemis.ConfigurationElement;
import com.artemis.SystemInvocationStrategy;
import com.artemis.WorldConfiguration;
import com.artemis.WorldConfigurationException;
import com.artemis.injection.CachedInjector;
import com.artemis.injection.FieldHandler;
import com.artemis.injection.FieldResolver;
import com.artemis.injection.InjectionCache;
import com.artemis.utils.Bag;
import com.artemis.utils.Sort;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.ReflectionException;

public class WorldConfigurationBuilder {
    private Bag<ConfigurationElement<? extends BaseSystem>> systems;
    private Bag<ConfigurationElement<? extends FieldResolver>> fieldResolvers;
    private Bag<ConfigurationElement<? extends ArtemisPlugin>> plugins;
    private boolean alwaysDelayComponentRemoval = false;
    private ArtemisPlugin activePlugin;
    private final InjectionCache cache;
    private SystemInvocationStrategy invocationStrategy;

    public WorldConfigurationBuilder() {
        this.reset();
        this.cache = (InjectionCache)InjectionCache.sharedCache.get();
    }

    public WorldConfiguration build() {
        this.appendPlugins();
        WorldConfiguration config = new WorldConfiguration();
        this.registerSystems(config);
        this.registerFieldResolvers(config);
        this.registerInvocationStrategies(config);
        config.setAlwaysDelayComponentRemoval(this.alwaysDelayComponentRemoval);
        this.reset();
        return config;
    }

    private void registerInvocationStrategies(WorldConfiguration config) {
        if (this.invocationStrategy != null) {
            config.setInvocationStrategy(this.invocationStrategy);
        }
    }

    private void appendPlugins() {
        for (int i = 0; i < this.plugins.size(); ++i) {
            this.activePlugin = (ArtemisPlugin)this.plugins.get((int)i).item;
            this.activePlugin.setup(this);
        }
        this.activePlugin = null;
    }

    protected void registerFieldResolvers(WorldConfiguration config) {
        if (this.fieldResolvers.size() > 0) {
            Sort.instance().sort(this.fieldResolvers);
            FieldHandler fieldHandler = new FieldHandler((InjectionCache)InjectionCache.sharedCache.get());
            for (ConfigurationElement<? extends FieldResolver> configurationElement : this.fieldResolvers) {
                fieldHandler.addFieldResolver((FieldResolver)configurationElement.item);
            }
            config.setInjector(new CachedInjector().setFieldHandler(fieldHandler));
        }
    }

    private void registerSystems(WorldConfiguration config) {
        Sort.instance().sort(this.systems);
        for (ConfigurationElement<? extends BaseSystem> configurationElement : this.systems) {
            config.setSystem((BaseSystem)configurationElement.item);
        }
    }

    private void reset() {
        this.invocationStrategy = null;
        this.systems = new Bag();
        this.fieldResolvers = new Bag();
        this.plugins = new Bag();
        this.alwaysDelayComponentRemoval = false;
    }

    public WorldConfigurationBuilder alwaysDelayComponentRemoval(boolean value) {
        this.alwaysDelayComponentRemoval = value;
        return this;
    }

    public WorldConfigurationBuilder register(FieldResolver ... fieldResolvers) {
        for (FieldResolver fieldResolver : fieldResolvers) {
            this.fieldResolvers.add(ConfigurationElement.of(fieldResolver));
        }
        return this;
    }

    public WorldConfigurationBuilder register(SystemInvocationStrategy strategy) {
        this.invocationStrategy = strategy;
        return this;
    }

    public final WorldConfigurationBuilder dependsOn(Class ... types) {
        return this.dependsOn(0, types);
    }

    public final WorldConfigurationBuilder dependsOn(int priority, Class ... types) {
        for (Class type : types) {
            try {
                switch (this.cache.getFieldClassType(type)) {
                    case SYSTEM: {
                        this.dependsOnSystem(priority, type);
                        break;
                    }
                    default: {
                        if (ClassReflection.isAssignableFrom(ArtemisPlugin.class, type)) {
                            if (priority != 0) {
                                throw new WorldConfigurationException("Priority not supported on plugins.");
                            }
                            this.dependsOnPlugin(type);
                            break;
                        }
                        throw new WorldConfigurationException("Unsupported type. Only supports systems.");
                    }
                }
            }
            catch (ReflectionException e) {
                throw new WorldConfigurationException("Unable to instance " + type + " via reflection.", e);
            }
        }
        return this;
    }

    protected void dependsOnSystem(int priority, Class<? extends BaseSystem> type) throws ReflectionException {
        if (!this.containsType(this.systems, type)) {
            this.systems.add(ConfigurationElement.of(ClassReflection.newInstance(type), priority));
        }
    }

    private void dependsOnPlugin(Class<? extends ArtemisPlugin> type) throws ReflectionException {
        if (ClassReflection.isAbstractClass(type)) {
            if (!this.anyAssignableTo(this.plugins, type)) {
                throw new WorldConfigurationException("Implementation of " + type + " expected but not found. Did you forget to include a plugin? (for example: logging-libgdx for logging-api)");
            }
        } else if (!this.containsType(this.plugins, type)) {
            this.plugins.add(ConfigurationElement.of(ClassReflection.newInstance(type)));
        }
    }

    public WorldConfigurationBuilder with(int priority, BaseSystem ... systems) {
        this.addSystems(priority, systems);
        return this;
    }

    public WorldConfigurationBuilder with(BaseSystem ... systems) {
        this.addSystems(0, systems);
        return this;
    }

    public WorldConfigurationBuilder with(ArtemisPlugin ... plugins) {
        this.addPlugins(plugins);
        return this;
    }

    private void addSystems(int priority, BaseSystem[] systems) {
        for (BaseSystem system : systems) {
            if (this.containsType(this.systems, system.getClass())) {
                throw new WorldConfigurationException("System of type " + system.getClass() + " registered twice. Only once allowed.");
            }
            this.systems.add(new ConfigurationElement<BaseSystem>(system, priority));
        }
    }

    private boolean containsType(Bag items, Class type) {
        for (ConfigurationElement registration : items) {
            if (registration.itemType != type) continue;
            return true;
        }
        return false;
    }

    private boolean anyAssignableTo(Bag items, Class type) {
        for (ConfigurationElement registration : items) {
            if (!ClassReflection.isAssignableFrom(type, registration.itemType)) continue;
            return true;
        }
        return false;
    }

    private void addPlugins(ArtemisPlugin[] plugins) {
        for (ArtemisPlugin plugin : plugins) {
            if (this.containsType(this.plugins, plugin.getClass())) {
                throw new WorldConfigurationException("Plugin of type " + plugin.getClass() + " registered twice. Only once allowed.");
            }
            this.plugins.add(ConfigurationElement.of(plugin));
        }
    }

    public static abstract class Priority {
        public static final int LOWEST = Integer.MIN_VALUE;
        public static final int LOW = -10000;
        public static final int OPERATIONS = -1000;
        public static final int NORMAL = 0;
        public static final int HIGH = 10000;
        public static final int HIGHEST = Integer.MAX_VALUE;
    }
}

