/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.injection;

import com.artemis.Archetype;
import com.artemis.ArchetypeBuilder;
import com.artemis.Aspect;
import com.artemis.Component;
import com.artemis.EntitySubscription;
import com.artemis.EntityTransmuter;
import com.artemis.World;
import com.artemis.annotations.All;
import com.artemis.annotations.AspectDescriptor;
import com.artemis.annotations.Exclude;
import com.artemis.annotations.One;
import com.artemis.injection.FieldResolver;
import com.artemis.utils.reflect.Annotation;
import com.artemis.utils.reflect.Field;
import java.util.IdentityHashMap;

public class AspectFieldResolver
implements FieldResolver {
    private static final Class<? extends Component>[] EMPTY_COMPONENT_CLASS_ARRAY = new Class[0];
    private World world;
    private IdentityHashMap<Field, Aspect.Builder> fields = new IdentityHashMap();

    @Override
    public void initialize(World world) {
        this.world = world;
    }

    @Override
    public Object resolve(Object target, Class<?> fieldType, Field field) {
        Aspect.Builder aspect = this.aspect(field);
        if (aspect == null) {
            return null;
        }
        if (Aspect.class == fieldType) {
            return this.world.getAspectSubscriptionManager().get(aspect).getAspect();
        }
        if (Aspect.Builder.class == fieldType) {
            return aspect;
        }
        if (EntityTransmuter.class == fieldType) {
            return new EntityTransmuter(this.world, aspect);
        }
        if (EntitySubscription.class == fieldType) {
            return this.world.getAspectSubscriptionManager().get(aspect);
        }
        if (Archetype.class == fieldType) {
            return new ArchetypeBuilder().add(this.allComponents(field)).build(this.world);
        }
        return null;
    }

    private Aspect.Builder aspect(Field field) {
        if (!this.fields.containsKey(field)) {
            AspectDescriptor descriptor = this.descriptor(field);
            if (descriptor != null) {
                this.fields.put(field, this.toAspect(descriptor));
            } else {
                All all = field.getAnnotation(All.class);
                One one = field.getAnnotation(One.class);
                Exclude exclude = field.getAnnotation(Exclude.class);
                if (all != null || one != null || exclude != null) {
                    this.fields.put(field, this.toAspect(all, one, exclude));
                } else {
                    this.fields.put(field, null);
                }
            }
        }
        return this.fields.get(field);
    }

    private AspectDescriptor descriptor(Field field) {
        Annotation anno = field.getDeclaredAnnotation(AspectDescriptor.class);
        return anno != null ? anno.getAnnotation(AspectDescriptor.class) : null;
    }

    private Aspect.Builder toAspect(AspectDescriptor ad) {
        return Aspect.all(ad.all()).one(ad.one()).exclude(ad.exclude());
    }

    private Aspect.Builder toAspect(All all, One one, Exclude exclude) {
        return Aspect.all(all != null ? all.value() : EMPTY_COMPONENT_CLASS_ARRAY).one(one != null ? one.value() : EMPTY_COMPONENT_CLASS_ARRAY).exclude(exclude != null ? exclude.value() : EMPTY_COMPONENT_CLASS_ARRAY);
    }

    private Class<? extends Component>[] allComponents(Field field) {
        AspectDescriptor descriptor = this.descriptor(field);
        if (descriptor != null) {
            return descriptor.all();
        }
        All all = field.getAnnotation(All.class);
        if (all != null) {
            return all.value();
        }
        return null;
    }
}

