/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.injection;

import com.artemis.InjectionException;
import com.artemis.World;
import com.artemis.injection.ArtemisFieldResolver;
import com.artemis.injection.AspectFieldResolver;
import com.artemis.injection.FieldResolver;
import com.artemis.injection.InjectionCache;
import com.artemis.injection.PojoFieldResolver;
import com.artemis.injection.UseInjectionCache;
import com.artemis.injection.WiredFieldResolver;
import com.artemis.utils.Bag;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Field;
import java.util.Map;

public class FieldHandler {
    private InjectionCache cache;
    protected Bag<FieldResolver> fieldResolvers;

    public FieldHandler(InjectionCache cache, Bag<FieldResolver> fieldResolvers) {
        this.cache = cache;
        this.fieldResolvers = fieldResolvers;
    }

    public FieldHandler(InjectionCache cache) {
        this.fieldResolvers = new Bag<FieldResolver>(FieldResolver.class);
        this.cache = cache;
        this.addFieldResolver(new WiredFieldResolver());
        this.addFieldResolver(new ArtemisFieldResolver());
        this.addFieldResolver(new AspectFieldResolver());
    }

    public void initialize(World world, Map<String, Object> injectables) {
        boolean fieldResolverFound = false;
        int s = this.fieldResolvers.size();
        for (int i = 0; i < s; ++i) {
            FieldResolver fieldResolver = this.fieldResolvers.get(i);
            if (ClassReflection.isInstance(UseInjectionCache.class, fieldResolver)) {
                ((UseInjectionCache)((Object)fieldResolver)).setCache(this.cache);
            }
            if (ClassReflection.isInstance(PojoFieldResolver.class, fieldResolver)) {
                ((PojoFieldResolver)fieldResolver).setPojos(injectables);
                fieldResolverFound = true;
            }
            fieldResolver.initialize(world);
        }
        if (injectables != null && !injectables.isEmpty() && !fieldResolverFound) {
            throw new InjectionException("FieldHandler lacks resolver capable of dealing with your custom injectables. Register a WiredFieldResolver or PojoFieldResolver with your FieldHandler.");
        }
    }

    public Object resolve(Object target, Class<?> fieldType, Field field) {
        int s = this.fieldResolvers.size();
        for (int i = 0; i < s; ++i) {
            Object resolved = this.fieldResolvers.get(i).resolve(target, fieldType, field);
            if (resolved == null) continue;
            return resolved;
        }
        return null;
    }

    public final void addFieldResolver(FieldResolver fieldResolver) {
        this.fieldResolvers.add(fieldResolver);
    }

    public Bag<FieldResolver> getFieldResolvers() {
        return this.fieldResolvers;
    }
}

