/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.injection;

import com.artemis.BaseSystem;
import com.artemis.ComponentMapper;
import com.artemis.World;
import com.artemis.annotations.SkipWire;
import com.artemis.annotations.Wire;
import com.artemis.injection.CachedClass;
import com.artemis.injection.CachedField;
import com.artemis.injection.ClassType;
import com.artemis.injection.SharedInjectionCache;
import com.artemis.injection.WireType;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Field;
import com.artemis.utils.reflect.ReflectionException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class InjectionCache {
    public static final SharedInjectionCache sharedCache = new SharedInjectionCache();
    private final Map<Class<?>, CachedClass> classCache = new HashMap();
    private final Map<Class<?>, ClassType> fieldClassTypeCache = new HashMap();
    private final Map<Field, CachedField> namedWireCache = new HashMap<Field, CachedField>();
    private final Map<Field, Class<?>> genericsCache = new HashMap();
    private static final Wire DEFAULT_WIRE = new Wire(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return Wire.class;
        }

        @Override
        public boolean injectInherited() {
            return true;
        }

        @Override
        public boolean failOnNull() {
            return true;
        }

        @Override
        public String name() {
            return null;
        }
    };

    public CachedClass getCachedClass(Class<?> clazz) throws ReflectionException {
        CachedClass cachedClass = this.classCache.get(clazz);
        if (cachedClass == null) {
            cachedClass = new CachedClass(clazz);
            cachedClass.wireType = this.getWireType(clazz);
            if (cachedClass.wireType == WireType.IGNORED && clazz != Object.class) {
                this.setWireAnnotation(cachedClass, DEFAULT_WIRE);
            } else if (cachedClass.wireType == WireType.WIRE) {
                this.setWireAnnotation(cachedClass, ClassReflection.getAnnotation(clazz, Wire.class));
            }
            this.classCache.put(clazz, cachedClass);
        }
        return cachedClass;
    }

    private void setWireAnnotation(CachedClass cachedClass, Wire wireAnnotation) {
        cachedClass.wireType = WireType.WIRE;
        cachedClass.wireAnnotation = wireAnnotation;
        cachedClass.failOnNull = wireAnnotation.failOnNull();
        cachedClass.injectInherited = wireAnnotation.injectInherited();
    }

    private WireType getWireType(Class<?> clazz) {
        return ClassReflection.isAnnotationPresent(clazz, Wire.class) ? WireType.WIRE : (ClassReflection.isAnnotationPresent(clazz, SkipWire.class) ? WireType.SKIPWIRE : WireType.IGNORED);
    }

    public CachedField getCachedField(Field field) {
        CachedField cachedField = this.namedWireCache.get(field);
        if (cachedField == null) {
            if (field.isAnnotationPresent(Wire.class)) {
                Wire wire = field.getAnnotation(Wire.class);
                cachedField = new CachedField(field, WireType.WIRE, wire.name(), wire.failOnNull());
            } else {
                cachedField = field.isAnnotationPresent(SkipWire.class) ? new CachedField(field, WireType.SKIPWIRE, null, false) : new CachedField(field, WireType.IGNORED, null, false);
            }
            this.namedWireCache.put(field, cachedField);
        }
        return cachedField;
    }

    public ClassType getFieldClassType(Class<?> fieldType) {
        ClassType injectionType = this.fieldClassTypeCache.get(fieldType);
        if (injectionType == null) {
            injectionType = ClassReflection.isAssignableFrom(ComponentMapper.class, fieldType) ? ClassType.MAPPER : (ClassReflection.isAssignableFrom(BaseSystem.class, fieldType) ? ClassType.SYSTEM : (ClassReflection.isAssignableFrom(World.class, fieldType) ? ClassType.WORLD : ClassType.CUSTOM));
            this.fieldClassTypeCache.put(fieldType, injectionType);
        }
        return injectionType;
    }

    public Class<?> getGenericType(Field field) {
        Class genericsType = this.genericsCache.get(field);
        if (genericsType == null) {
            genericsType = field.getElementType(0);
            this.genericsCache.put(field, genericsType);
        }
        return genericsType;
    }
}

