/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.injection;

import com.artemis.MundaneWireException;
import com.artemis.World;
import com.artemis.injection.CachedField;
import com.artemis.injection.ClassType;
import com.artemis.injection.InjectionCache;
import com.artemis.injection.PojoFieldResolver;
import com.artemis.injection.UseInjectionCache;
import com.artemis.injection.WireType;
import com.artemis.utils.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class WiredFieldResolver
implements UseInjectionCache,
PojoFieldResolver {
    private InjectionCache cache;
    private Map<String, Object> pojos = new HashMap<String, Object>();
    private World world;

    @Override
    public void initialize(World world) {
        this.world = world;
    }

    @Override
    public Object resolve(Object target, Class<?> fieldType, Field field) {
        ClassType injectionType = this.cache.getFieldClassType(fieldType);
        CachedField cachedField = this.cache.getCachedField(field);
        if ((injectionType == ClassType.CUSTOM || injectionType == ClassType.WORLD) && cachedField.wireType == WireType.WIRE) {
            String key = cachedField.name;
            if ("".equals(key)) {
                key = field.getType().getName();
            }
            if (!this.pojos.containsKey(key) && cachedField.failOnNull) {
                String err = "Not registered: " + key + "=" + fieldType;
                throw new MundaneWireException(err);
            }
            return this.pojos.get(key);
        }
        return null;
    }

    @Override
    public void setCache(InjectionCache cache) {
        this.cache = cache;
    }

    @Override
    public void setPojos(Map<String, Object> pojos) {
        this.pojos = pojos;
    }
}

