/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.link;

import com.artemis.Aspect;
import com.artemis.Component;
import com.artemis.Entity;
import com.artemis.EntitySubscription;
import com.artemis.World;
import com.artemis.link.LinkListener;
import com.artemis.link.MultiFieldMutator;
import com.artemis.utils.Bag;
import com.artemis.utils.reflect.Field;
import com.artemis.utils.reflect.ReflectionException;

class EntityBagFieldMutator
implements MultiFieldMutator<Bag<Entity>, Component> {
    private final Bag<Entity> empty = new Bag();
    private EntitySubscription all;

    EntityBagFieldMutator() {
    }

    @Override
    public void validate(int sourceId, Bag<Entity> entities, LinkListener listener) {
        for (int i = 0; entities.size() > i; ++i) {
            Entity e = entities.get(i);
            if (this.all.getActiveEntityIds().unsafeGet(e.getId())) continue;
            entities.remove(i--);
            if (listener == null) continue;
            listener.onTargetDead(sourceId, e.getId());
        }
    }

    @Override
    public Bag<Entity> read(Component c, Field f) {
        try {
            Bag<Entity> e = (Bag<Entity>)f.get(c);
            return e != null ? e : this.empty;
        }
        catch (ReflectionException exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public void setWorld(World world) {
        this.all = world.getAspectSubscriptionManager().get(Aspect.all());
    }
}

