/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.link;

import com.artemis.Aspect;
import com.artemis.BaseEntitySystem;
import com.artemis.Component;
import com.artemis.ComponentType;
import com.artemis.ComponentTypeFactory;
import com.artemis.annotations.SkipWire;
import com.artemis.link.LinkFactory;
import com.artemis.link.LinkListener;
import com.artemis.link.LinkSite;
import com.artemis.utils.Bag;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Field;
import com.artemis.utils.reflect.ReflectionException;

@SkipWire
public class EntityLinkManager
extends BaseEntitySystem {
    final Bag<LinkSite> linkSites = new Bag();
    final Bag<LinkSite> decoratedLinkSites = new Bag();
    private final boolean requireListener;
    private final boolean fireEventsOnRegistration;

    public EntityLinkManager(boolean processSitesEvenIfNoListener, boolean fireEventsOnRegistration) {
        super(Aspect.all());
        this.requireListener = !processSitesEvenIfNoListener;
        this.fireEventsOnRegistration = fireEventsOnRegistration;
    }

    public EntityLinkManager() {
        this(true, true);
    }

    @Override
    protected void initialize() {
        LinkCreateListener listener = new LinkCreateListener(this);
        this.world.getComponentManager().getTypeFactory().register(listener);
    }

    @Override
    protected void processSystem() {
        if (this.requireListener) {
            this.process(this.decoratedLinkSites);
        } else {
            this.process(this.linkSites);
        }
    }

    private void process(Bag<LinkSite> sites) {
        for (LinkSite ls : sites) {
            ls.process();
        }
    }

    public void register(Class<? extends Component> component, LinkListener listener) {
        this.register(component, null, listener);
    }

    public void register(Class<? extends Component> component, String field, LinkListener listener) {
        this.world.inject(listener);
        try {
            Field f = field != null ? ClassReflection.getDeclaredField(component, field) : null;
            ComponentType ct = this.world.getComponentManager().getTypeFactory().getTypeFor(component);
            for (LinkSite site : this.linkSites) {
                if (!ct.equals(site.type) || f != null && !site.field.equals(f)) continue;
                site.listener = listener;
                if (!this.decoratedLinkSites.contains(site)) {
                    this.decoratedLinkSites.add(site);
                }
                if (!this.fireEventsOnRegistration) continue;
                site.inserted(site.subscription.getEntities());
            }
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    private static class LinkCreateListener
    implements ComponentTypeFactory.ComponentTypeListener {
        private final EntityLinkManager elm;
        private final LinkFactory linkFactory;

        public LinkCreateListener(EntityLinkManager elm) {
            this.elm = elm;
            this.linkFactory = new LinkFactory(elm.getWorld());
        }

        @Override
        public void initialize(Bag<ComponentType> types) {
            int s = types.size();
            for (int i = 0; s > i; ++i) {
                this.onCreated(types.get(i));
            }
        }

        @Override
        public void onCreated(ComponentType type) {
            Bag<LinkSite> links = this.linkFactory.create(type);
            if (links.isEmpty()) {
                return;
            }
            int s = links.size();
            for (int i = 0; s > i; ++i) {
                this.elm.linkSites.add(links.get(i));
            }
        }
    }
}

