/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.link;

import com.artemis.Aspect;
import com.artemis.Component;
import com.artemis.EntitySubscription;
import com.artemis.World;
import com.artemis.link.LinkListener;
import com.artemis.link.MultiFieldMutator;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.Field;
import com.artemis.utils.reflect.ReflectionException;

class IntBagFieldMutator
implements MultiFieldMutator<IntBag, Component> {
    private final IntBag empty = new IntBag();
    private EntitySubscription all;

    IntBagFieldMutator() {
    }

    @Override
    public void validate(int sourceId, IntBag ids, LinkListener listener) {
        for (int i = 0; ids.size() > i; ++i) {
            int id = ids.get(i);
            if (this.all.getActiveEntityIds().unsafeGet(id)) continue;
            ids.removeIndex(i--);
            if (listener == null) continue;
            listener.onTargetDead(sourceId, id);
        }
    }

    @Override
    public IntBag read(Component c, Field f) {
        try {
            boolean isNotAccessible;
            boolean bl = isNotAccessible = !f.isAccessible();
            if (isNotAccessible) {
                f.setAccessible(true);
            }
            IntBag e = (IntBag)f.get(c);
            if (isNotAccessible) {
                f.setAccessible(false);
            }
            return e != null ? e : this.empty;
        }
        catch (ReflectionException exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public void setWorld(World world) {
        this.all = world.getAspectSubscriptionManager().get(Aspect.all());
    }
}

