/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.link;

import com.artemis.Component;
import com.artemis.ComponentType;
import com.artemis.Entity;
import com.artemis.World;
import com.artemis.annotations.EntityId;
import com.artemis.annotations.LinkPolicy;
import com.artemis.link.EntityBagFieldMutator;
import com.artemis.link.EntityFieldMutator;
import com.artemis.link.IntBagFieldMutator;
import com.artemis.link.IntFieldMutator;
import com.artemis.link.LinkSite;
import com.artemis.link.MultiFieldMutator;
import com.artemis.link.MultiLinkSite;
import com.artemis.link.MutatorUtil;
import com.artemis.link.UniFieldMutator;
import com.artemis.link.UniLinkSite;
import com.artemis.utils.Bag;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.Annotation;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Field;
import com.artemis.utils.reflect.ReflectionUtil;

class LinkFactory {
    private static final int NULL_REFERENCE = 0;
    private static final int SINGLE_REFERENCE = 1;
    private static final int MULTI_REFERENCE = 2;
    private final Bag<LinkSite> links = new Bag();
    private final World world;
    private final ReflexiveMutators reflexiveMutators;

    public LinkFactory(World world) {
        this.world = world;
        this.reflexiveMutators = new ReflexiveMutators(world);
    }

    static int getReferenceTypeId(Field f) {
        boolean explicitEntityId;
        Class type = f.getType();
        if (Entity.class == type) {
            return 1;
        }
        if (ReflectionUtil.isGenericType(f, Bag.class, Entity.class)) {
            return 2;
        }
        boolean bl = explicitEntityId = f.getDeclaredAnnotation(EntityId.class) != null;
        if (Integer.TYPE == type && explicitEntityId) {
            return 1;
        }
        if (IntBag.class == type && explicitEntityId) {
            return 2;
        }
        return 0;
    }

    Bag<LinkSite> create(ComponentType ct) {
        Class<? extends Component> type = ct.getType();
        Field[] fields = ClassReflection.getDeclaredFields(type);
        this.links.clear();
        for (int i = 0; fields.length > i; ++i) {
            LinkSite ls;
            Field f = fields[i];
            int referenceTypeId = LinkFactory.getReferenceTypeId(f);
            if (referenceTypeId == 0 || LinkPolicy.Policy.SKIP == LinkFactory.getPolicy(f)) continue;
            if (1 == referenceTypeId) {
                ls = new UniLinkSite(this.world, ct, f);
                if (!this.configureMutator((UniLinkSite)ls)) {
                    this.reflexiveMutators.withMutator((UniLinkSite)ls);
                }
                this.links.add(ls);
                continue;
            }
            if (2 != referenceTypeId) continue;
            ls = new MultiLinkSite(this.world, ct, f);
            if (!this.configureMutator((MultiLinkSite)ls)) {
                this.reflexiveMutators.withMutator((MultiLinkSite)ls);
            }
            this.links.add(ls);
        }
        return this.links;
    }

    static LinkPolicy.Policy getPolicy(Field f) {
        Annotation annotation = f.getDeclaredAnnotation(LinkPolicy.class);
        if (annotation != null) {
            LinkPolicy lp = annotation.getAnnotation(LinkPolicy.class);
            return lp != null ? lp.value() : null;
        }
        return null;
    }

    private boolean configureMutator(UniLinkSite linkSite) {
        UniFieldMutator mutator = (UniFieldMutator)MutatorUtil.getGeneratedMutator(linkSite);
        if (mutator != null) {
            mutator.setWorld(this.world);
            linkSite.fieldMutator = mutator;
            return true;
        }
        return false;
    }

    private boolean configureMutator(MultiLinkSite linkSite) {
        MultiFieldMutator mutator = (MultiFieldMutator)MutatorUtil.getGeneratedMutator(linkSite);
        if (mutator != null) {
            mutator.setWorld(this.world);
            linkSite.fieldMutator = mutator;
            return true;
        }
        return false;
    }

    static class ReflexiveMutators {
        final EntityFieldMutator entityField = new EntityFieldMutator();
        final IntFieldMutator intField;
        final IntBagFieldMutator intBagField;
        final EntityBagFieldMutator entityBagField;

        public ReflexiveMutators(World world) {
            this.entityField.setWorld(world);
            this.intField = new IntFieldMutator();
            this.intField.setWorld(world);
            this.intBagField = new IntBagFieldMutator();
            this.intBagField.setWorld(world);
            this.entityBagField = new EntityBagFieldMutator();
            this.entityBagField.setWorld(world);
        }

        UniLinkSite withMutator(UniLinkSite linkSite) {
            if (linkSite.fieldMutator != null) {
                return linkSite;
            }
            Class type = linkSite.field.getType();
            if (Entity.class == type) {
                linkSite.fieldMutator = this.entityField;
            } else if (Integer.TYPE == type) {
                linkSite.fieldMutator = this.intField;
            } else {
                throw new RuntimeException("unexpected '" + type + "', on " + linkSite.type);
            }
            return linkSite;
        }

        MultiLinkSite withMutator(MultiLinkSite linkSite) {
            if (linkSite.fieldMutator != null) {
                return linkSite;
            }
            Class type = linkSite.field.getType();
            if (IntBag.class == type) {
                linkSite.fieldMutator = this.intBagField;
            } else if (Bag.class == type) {
                linkSite.fieldMutator = this.entityBagField;
            } else {
                throw new RuntimeException("unexpected '" + type + "', on " + linkSite.type);
            }
            return linkSite;
        }
    }
}

