/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.link;

import com.artemis.Aspect;
import com.artemis.AspectSubscriptionManager;
import com.artemis.Component;
import com.artemis.ComponentMapper;
import com.artemis.ComponentType;
import com.artemis.EntitySubscription;
import com.artemis.World;
import com.artemis.annotations.LinkPolicy;
import com.artemis.link.LinkFactory;
import com.artemis.link.LinkListener;
import com.artemis.utils.BitVector;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.Field;

abstract class LinkSite
implements EntitySubscription.SubscriptionListener {
    protected final ComponentType type;
    protected final Field field;
    protected final ComponentMapper<? extends Component> mapper;
    protected final EntitySubscription subscription;
    protected final LinkPolicy.Policy policy;
    protected final BitVector activeEntityIds;
    protected LinkListener listener;

    protected LinkSite(World world, ComponentType type, Field field, LinkPolicy.Policy defaultPolicy) {
        this.type = type;
        this.field = field;
        LinkPolicy.Policy policyOverride = LinkFactory.getPolicy(field);
        this.policy = policyOverride != null ? policyOverride : defaultPolicy;
        this.mapper = world.getMapper(type.getType());
        this.activeEntityIds = world.getAspectSubscriptionManager().get(Aspect.all()).getActiveEntityIds();
        AspectSubscriptionManager subscriptions = world.getAspectSubscriptionManager();
        this.subscription = subscriptions.get(Aspect.all(type.getType()));
        this.subscription.addSubscriptionListener(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkSite that = (LinkSite)o;
        return this.type.equals(that.type) && this.field.equals(that.field);
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.field.hashCode();
    }

    @Override
    public void inserted(IntBag entities) {
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            this.insert(ids[i]);
        }
    }

    protected abstract void insert(int var1);

    @Override
    public void removed(IntBag entities) {
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            this.removed(ids[i]);
        }
    }

    protected abstract void removed(int var1);

    protected abstract void check(int var1);

    protected void process() {
        if (LinkPolicy.Policy.CHECK_SOURCE_AND_TARGETS != this.policy) {
            return;
        }
        IntBag entities = this.subscription.getEntities();
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            this.check(ids[i]);
        }
    }
}

