/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.link;

import com.artemis.ComponentType;
import com.artemis.World;
import com.artemis.annotations.LinkPolicy;
import com.artemis.link.LinkSite;
import com.artemis.link.MultiFieldMutator;
import com.artemis.utils.reflect.Field;

class MultiLinkSite
extends LinkSite {
    MultiFieldMutator fieldMutator;

    protected MultiLinkSite(World world, ComponentType type, Field field) {
        super(world, type, field, LinkPolicy.Policy.CHECK_SOURCE);
    }

    @Override
    protected void check(int id) {
        Object collection = this.fieldMutator.read(this.mapper.get(id), this.field);
        this.fieldMutator.validate(id, collection, this.listener);
    }

    @Override
    protected void insert(int id) {
        if (this.listener != null) {
            this.listener.onLinkEstablished(id, -1);
        }
    }

    @Override
    protected void removed(int id) {
        if (this.listener != null) {
            this.listener.onLinkKilled(id, -1);
        }
    }
}

