/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.link;

import com.artemis.link.LinkSite;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.ReflectionException;

final class MutatorUtil {
    private MutatorUtil() {
    }

    static <T> T getGeneratedMutator(LinkSite linkSite) {
        Class<?>[] possibleMutators = linkSite.field.getDeclaringClass().getDeclaredClasses();
        String mutatorName = "Mutator_" + linkSite.field.getName();
        int s = possibleMutators.length;
        for (int i = 0; s > i; ++i) {
            if (!mutatorName.equals(possibleMutators[i].getSimpleName())) continue;
            try {
                return (T)ClassReflection.newInstance(possibleMutators[i]);
            }
            catch (ReflectionException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

