/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.link;

import com.artemis.Component;
import com.artemis.ComponentType;
import com.artemis.World;
import com.artemis.annotations.LinkPolicy;
import com.artemis.link.LinkSite;
import com.artemis.link.UniFieldMutator;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.Field;

class UniLinkSite
extends LinkSite {
    UniFieldMutator fieldMutator;
    private final IntBag sourceToTarget = new IntBag();

    protected UniLinkSite(World world, ComponentType type, Field field) {
        super(world, type, field, LinkPolicy.Policy.CHECK_SOURCE_AND_TARGETS);
    }

    @Override
    protected void check(int id) {
        int oldTarget;
        int target = this.fieldMutator.read((Component)this.mapper.get(id), this.field);
        if (target != -1 && !this.activeEntityIds.unsafeGet(target)) {
            target = -1;
            this.fieldMutator.write(target, (Component)this.mapper.get(id), this.field);
        }
        if (target != (oldTarget = this.sourceToTarget.get(id))) {
            if (this.listener != null) {
                this.fireLinkListener(id, target);
            }
            this.sourceToTarget.set(id, target);
        }
    }

    private void fireLinkListener(int id, int target) {
        int oldTarget = this.sourceToTarget.get(id);
        if (oldTarget == -1) {
            this.listener.onLinkEstablished(id, target);
        } else if (target != -1) {
            this.listener.onTargetChanged(id, target, oldTarget);
        } else {
            this.listener.onTargetDead(id, oldTarget);
        }
    }

    @Override
    protected void insert(int id) {
        int target = this.fieldMutator.read((Component)this.mapper.get(id), this.field);
        this.sourceToTarget.set(id, target);
        if (target != -1 && this.listener != null) {
            this.listener.onLinkEstablished(id, target);
        }
    }

    @Override
    protected void removed(int id) {
        int target;
        int n = target = this.sourceToTarget.size() > id ? this.sourceToTarget.get(id) : -1;
        if (target != -1) {
            this.sourceToTarget.set(id, -1);
        }
        if (this.listener != null) {
            this.listener.onLinkKilled(id, target);
        }
    }
}

