/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.managers;

import com.artemis.Aspect;
import com.artemis.BaseSystem;
import com.artemis.Entity;
import com.artemis.EntitySubscription;
import com.artemis.utils.Bag;
import com.artemis.utils.ImmutableBag;
import com.artemis.utils.ImmutableIntBag;
import com.artemis.utils.IntBag;
import java.util.HashMap;
import java.util.Map;

public class GroupManager
extends BaseSystem {
    private static final ImmutableBag<String> EMPTY_BAG = new Bag<String>();
    private final Map<String, Bag<Entity>> entitiesByGroup = new HashMap<String, Bag<Entity>>();
    private final Map<String, IntBag> identitiesByGroup = new HashMap<String, IntBag>();
    private final Map<Entity, Bag<String>> groupsByEntity = new HashMap<Entity, Bag<String>>();

    @Override
    protected void processSystem() {
    }

    @Override
    protected void initialize() {
        this.world.getAspectSubscriptionManager().get(Aspect.all()).addSubscriptionListener(new EntitySubscription.SubscriptionListener(){

            @Override
            public void inserted(IntBag entities) {
            }

            @Override
            public void removed(IntBag entities) {
                GroupManager.this.deleted(entities);
            }
        });
    }

    public void add(Entity e, String group) {
        Bag<String> groups;
        IntBag identities;
        Bag<Entity> entities = this.entitiesByGroup.get(group);
        if (entities == null) {
            entities = new Bag();
            this.entitiesByGroup.put(group, entities);
        }
        if ((identities = this.identitiesByGroup.get(group)) == null) {
            identities = new IntBag();
            this.identitiesByGroup.put(group, identities);
        }
        if (!entities.contains(e)) {
            entities.add(e);
            identities.add(e.getId());
        }
        if ((groups = this.groupsByEntity.get(e)) == null) {
            groups = new Bag();
            this.groupsByEntity.put(e, groups);
        }
        if (!groups.contains(group)) {
            groups.add(group);
        }
    }

    public void add(int entityId, String group) {
        Entity e = this.world.getEntity(entityId);
        this.add(e, group);
    }

    public void add(Entity e, String g1, String g2) {
        this.add(e, g1);
        this.add(e, g2);
    }

    public void add(int entityId, String g1, String g2) {
        Entity e = this.world.getEntity(entityId);
        this.add(e, g1, g2);
    }

    public void add(Entity e, String g1, String g2, String g3) {
        this.add(e, g1);
        this.add(e, g2);
        this.add(e, g3);
    }

    public void add(int entityId, String g1, String g2, String g3) {
        Entity e = this.world.getEntity(entityId);
        this.add(e, g1, g2, g3);
    }

    public void add(Entity e, String ... groups) {
        for (String group : groups) {
            this.add(e, group);
        }
    }

    public void add(int entityId, String ... groups) {
        Entity e = this.world.getEntity(entityId);
        this.add(e, groups);
    }

    public void remove(Entity e, String group) {
        Bag<String> groups;
        IntBag identities;
        Bag<Entity> entities = this.entitiesByGroup.get(group);
        if (entities != null) {
            entities.remove(e);
        }
        if ((identities = this.identitiesByGroup.get(group)) != null) {
            identities.removeValue(e.getId());
        }
        if ((groups = this.groupsByEntity.get(e)) != null) {
            groups.remove(group);
            if (groups.size() == 0) {
                this.groupsByEntity.remove(e);
            }
        }
    }

    public void remove(int entityId, String group) {
        this.remove(this.world.getEntity(entityId), group);
    }

    public void remove(Entity e, String g1, String g2) {
        this.remove(e, g1);
        this.remove(e, g2);
    }

    public void remove(int entityId, String g1, String g2) {
        this.remove(this.world.getEntity(entityId), g1, g2);
    }

    public void remove(Entity e, String g1, String g2, String g3) {
        this.remove(e, g1);
        this.remove(e, g2);
        this.remove(e, g3);
    }

    public void remove(int entityId, String g1, String g2, String g3) {
        this.remove(this.world.getEntity(entityId), g1, g2, g3);
    }

    public void remove(Entity e, String ... groups) {
        for (String group : groups) {
            this.remove(e, group);
        }
    }

    public void remove(int entityId, String ... groups) {
        this.remove(this.world.getEntity(entityId), groups);
    }

    public void removeFromAllGroups(Entity e) {
        Bag<String> groups = this.groupsByEntity.get(e);
        if (groups == null) {
            return;
        }
        int s = groups.size();
        for (int i = 0; s > i; ++i) {
            IntBag identities;
            Bag<Entity> entities = this.entitiesByGroup.get(groups.get(i));
            if (entities != null) {
                entities.remove(e);
            }
            if ((identities = this.identitiesByGroup.get(groups.get(i))) == null) continue;
            identities.removeValue(e.getId());
        }
        this.groupsByEntity.remove(e);
    }

    public void removeFromAllGroups(int entityId) {
        Entity e = this.world.getEntity(entityId);
        this.removeFromAllGroups(e);
    }

    public ImmutableBag<Entity> getEntities(String group) {
        Bag<Entity> entities = this.entitiesByGroup.get(group);
        if (entities == null) {
            entities = new Bag();
            this.entitiesByGroup.put(group, entities);
        }
        return entities;
    }

    public ImmutableIntBag getEntityIds(String group) {
        IntBag identities = this.identitiesByGroup.get(group);
        if (identities == null) {
            identities = new IntBag();
            this.identitiesByGroup.put(group, identities);
        }
        return identities;
    }

    public ImmutableBag<String> getGroups(Entity e) {
        Bag<String> groups = this.groupsByEntity.get(e);
        return groups != null ? groups : EMPTY_BAG;
    }

    public ImmutableBag<String> getGroups(int entityId) {
        Entity e = this.world.getEntity(entityId);
        return this.getGroups(e);
    }

    public boolean isInAnyGroup(Entity e) {
        return this.getGroups(e).size() > 0;
    }

    public boolean isInAnyGroup(int entityId) {
        Entity e = this.world.getEntity(entityId);
        return this.isInAnyGroup(e);
    }

    public boolean isInGroup(Entity e, String group) {
        Bag<String> bag;
        if (group != null && (bag = this.groupsByEntity.get(e)) != null) {
            String[] groups = bag.getData();
            int s = bag.size();
            for (int i = 0; s > i; ++i) {
                String g = groups[i];
                if (!group.equals(g)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInGroup(int entityId, String group) {
        Entity e = this.world.getEntity(entityId);
        return this.isInGroup(e, group);
    }

    void deleted(IntBag entities) {
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            this.removeFromAllGroups(this.world.getEntity(ids[i]));
        }
    }
}

