/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.managers;

import com.artemis.Aspect;
import com.artemis.BaseSystem;
import com.artemis.Entity;
import com.artemis.EntitySubscription;
import com.artemis.utils.BitVector;
import com.artemis.utils.IntBag;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TagManager
extends BaseSystem {
    private final Map<String, Entity> entitiesByTag = new HashMap<String, Entity>();
    private final Map<Entity, String> tagsByEntity = new HashMap<Entity, String>();
    private final BitVector registered = new BitVector();

    @Override
    protected void processSystem() {
    }

    @Override
    protected void initialize() {
        this.world.getAspectSubscriptionManager().get(Aspect.all()).addSubscriptionListener(new EntitySubscription.SubscriptionListener(){

            @Override
            public void inserted(IntBag entities) {
            }

            @Override
            public void removed(IntBag entities) {
                TagManager.this.deleted(entities);
            }
        });
    }

    void deleted(IntBag entities) {
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            int id = ids[i];
            if (!this.registered.get(id)) continue;
            String removedTag = this.tagsByEntity.remove(this.world.getEntity(id));
            this.entitiesByTag.remove(removedTag);
            this.registered.clear(id);
        }
    }

    public void register(String tag, Entity e) {
        this.unregister(tag);
        if (this.getTag(e) != null) {
            this.unregister(this.getTag(e));
        }
        this.entitiesByTag.put(tag, e);
        this.tagsByEntity.put(e, tag);
        this.registered.set(e.getId());
    }

    public void register(String tag, int entityId) {
        this.register(tag, this.world.getEntity(entityId));
    }

    public void unregister(String tag) {
        Entity removed = this.entitiesByTag.remove(tag);
        if (removed != null) {
            this.tagsByEntity.remove(removed);
            this.registered.clear(removed.getId());
        }
    }

    public boolean isRegistered(String tag) {
        return this.entitiesByTag.containsKey(tag);
    }

    public Entity getEntity(String tag) {
        return this.entitiesByTag.get(tag);
    }

    public int getEntityId(String tag) {
        Entity e = this.getEntity(tag);
        return e != null ? e.getId() : -1;
    }

    public String getTag(Entity entity) {
        return this.tagsByEntity.get(entity);
    }

    public String getTag(int entityId) {
        return this.getTag(this.world.getEntity(entityId));
    }

    public Collection<String> getRegisteredTags() {
        return this.tagsByEntity.values();
    }
}

