/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.managers;

import com.artemis.Entity;
import com.artemis.Manager;
import com.artemis.utils.Bag;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class UuidEntityManager
extends Manager {
    private final Map<UUID, Entity> uuidToEntity = new HashMap<UUID, Entity>();
    private final Bag<UUID> entityToUuid = new Bag();

    @Override
    public void deleted(Entity e) {
        UUID uuid = this.entityToUuid.safeGet(e.getId());
        if (uuid == null) {
            return;
        }
        Entity oldEntity = this.uuidToEntity.get(uuid);
        if (oldEntity != null && oldEntity.equals(e)) {
            this.uuidToEntity.remove(uuid);
        }
        this.entityToUuid.set(e.getId(), null);
    }

    public void updatedUuid(Entity e, UUID newUuid) {
        this.setUuid(e, newUuid);
    }

    public Entity getEntity(UUID uuid) {
        return this.uuidToEntity.get(uuid);
    }

    public UUID getUuid(Entity e) {
        UUID uuid = this.entityToUuid.safeGet(e.getId());
        if (uuid == null) {
            uuid = UUID.randomUUID();
            this.setUuid(e, uuid);
        }
        return uuid;
    }

    public void setUuid(Entity e, UUID newUuid) {
        UUID oldUuid = this.entityToUuid.safeGet(e.getId());
        if (oldUuid != null) {
            this.uuidToEntity.remove(oldUuid);
        }
        this.uuidToEntity.put(newUuid, e);
        this.entityToUuid.set(e.getId(), newUuid);
    }
}

