/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.systems;

import com.artemis.Aspect;
import com.artemis.BaseEntitySystem;
import com.artemis.utils.IntBag;

public abstract class DelayedIteratingSystem
extends BaseEntitySystem {
    private float delay;
    private boolean running;
    private float acc;

    public DelayedIteratingSystem(Aspect.Builder aspect) {
        super(aspect);
    }

    public DelayedIteratingSystem() {
    }

    @Override
    protected final void processSystem() {
        IntBag entities = this.subscription.getEntities();
        int processed = entities.size();
        if (processed == 0) {
            this.stop();
            return;
        }
        this.delay = Float.MAX_VALUE;
        int[] ids = entities.getData();
        for (int i = 0; processed > i; ++i) {
            int e = ids[i];
            this.processDelta(e, this.acc);
            float remaining = this.getRemainingDelay(e);
            if (remaining <= 0.0f) {
                this.processExpired(e);
                continue;
            }
            this.offerDelay(remaining);
        }
        this.acc = 0.0f;
    }

    @Override
    protected void inserted(int entityId) {
        float remainingDelay = this.getRemainingDelay(entityId);
        this.processDelta(entityId, -this.acc);
        if (remainingDelay > 0.0f) {
            this.offerDelay(remainingDelay);
        }
    }

    protected abstract float getRemainingDelay(int var1);

    @Override
    protected final boolean checkProcessing() {
        if (this.running) {
            this.acc += this.getTimeDelta();
            return this.acc >= this.delay;
        }
        return false;
    }

    protected float getTimeDelta() {
        return this.world.getDelta();
    }

    protected abstract void processDelta(int var1, float var2);

    protected abstract void processExpired(int var1);

    public void offerDelay(float offeredDelay) {
        if (!this.running) {
            this.running = true;
            this.delay = offeredDelay;
        } else {
            this.delay = Math.min(this.delay, offeredDelay);
        }
    }

    public float getInitialTimeDelay() {
        return this.delay;
    }

    public float getRemainingTimeUntilProcessing() {
        if (this.running) {
            return this.delay - this.acc;
        }
        return 0.0f;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        this.running = false;
        this.acc = 0.0f;
    }
}

