/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.utils;

import com.artemis.ComponentManager;
import com.artemis.utils.IntBag;
import java.util.Arrays;

public class BitVector {
    long[] words = new long[]{0L};

    public BitVector() {
    }

    public BitVector(int nbits) {
        this.checkCapacity(nbits >>> 6);
    }

    public BitVector(BitVector copyFrom) {
        this.words = Arrays.copyOf(copyFrom.words, copyFrom.words.length);
    }

    public boolean get(int index) {
        int word = index >>> 6;
        return word < this.words.length && (this.words[word] & 1L << index) != 0L;
    }

    public void set(int index) {
        int word = index >>> 6;
        this.checkCapacity(word);
        int n = word;
        this.words[n] = this.words[n] | 1L << index;
    }

    public void set(int index, boolean value) {
        if (value) {
            this.set(index);
        } else {
            this.clear(index);
        }
    }

    public boolean unsafeGet(int index) {
        return (this.words[index >>> 6] & 1L << index) != 0L;
    }

    public void unsafeSet(int index) {
        int n = index >>> 6;
        this.words[n] = this.words[n] | 1L << index;
    }

    public void unsafeSet(int index, boolean value) {
        if (value) {
            this.unsafeSet(index);
        } else {
            this.unsafeClear(index);
        }
    }

    public void flip(int index) {
        int word = index >>> 6;
        this.checkCapacity(word);
        int n = word;
        this.words[n] = this.words[n] ^ 1L << index;
    }

    public void ensureCapacity(int bits) {
        this.checkCapacity(bits >>> 6);
    }

    private void checkCapacity(int len) {
        if (len >= this.words.length) {
            long[] newBits = new long[len + 1];
            System.arraycopy(this.words, 0, newBits, 0, this.words.length);
            this.words = newBits;
        }
    }

    public void clear(int index) {
        int word = index >>> 6;
        if (word >= this.words.length) {
            return;
        }
        int n = word;
        this.words[n] = this.words[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void unsafeClear(int index) {
        int n = index >>> 6;
        this.words[n] = this.words[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear() {
        Arrays.fill(this.words, 0L);
    }

    public int length() {
        long[] bits = this.words;
        for (int word = bits.length - 1; word >= 0; --word) {
            long bitsAtWord = bits[word];
            if (bitsAtWord == 0L) continue;
            return (word << 6) + 64 - Long.numberOfLeadingZeros(bitsAtWord);
        }
        return 0;
    }

    public boolean isEmpty() {
        long[] bits = this.words;
        int length = bits.length;
        for (int i = 0; i < length; ++i) {
            if (bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public int nextSetBit(int fromIndex) {
        int word = fromIndex >>> 6;
        if (word >= this.words.length) {
            return -1;
        }
        long bitmap = this.words[word] >>> fromIndex;
        if (bitmap != 0L) {
            return fromIndex + Long.numberOfTrailingZeros(bitmap);
        }
        for (int i = 1 + word; i < this.words.length; ++i) {
            bitmap = this.words[i];
            if (bitmap == 0L) continue;
            return i * 64 + Long.numberOfTrailingZeros(bitmap);
        }
        return -1;
    }

    public int nextClearBit(int fromIndex) {
        int word = fromIndex >>> 6;
        if (word >= this.words.length) {
            return Math.min(fromIndex, this.words.length << 6);
        }
        long bitmap = this.words[word] >>> fromIndex ^ 0xFFFFFFFFFFFFFFFFL;
        if (bitmap != 0L) {
            return fromIndex + Long.numberOfTrailingZeros(bitmap);
        }
        for (int i = 1 + word; i < this.words.length; ++i) {
            bitmap = this.words[i] ^ 0xFFFFFFFFFFFFFFFFL;
            if (bitmap == 0L) continue;
            return i * 64 + Long.numberOfTrailingZeros(bitmap);
        }
        return Math.min(fromIndex, this.words.length << 6);
    }

    public void and(BitVector other) {
        int i;
        int commonWords = Math.min(this.words.length, other.words.length);
        for (i = 0; commonWords > i; ++i) {
            int n = i;
            this.words[n] = this.words[n] & other.words[i];
        }
        if (this.words.length > commonWords) {
            int s = this.words.length;
            for (i = commonWords; s > i; ++i) {
                this.words[i] = 0L;
            }
        }
    }

    public void andNot(BitVector other) {
        int commonWords = Math.min(this.words.length, other.words.length);
        for (int i = 0; commonWords > i; ++i) {
            int n = i;
            this.words[n] = this.words[n] & (other.words[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void or(BitVector other) {
        int i;
        int commonWords = Math.min(this.words.length, other.words.length);
        for (i = 0; commonWords > i; ++i) {
            int n = i;
            this.words[n] = this.words[n] | other.words[i];
        }
        if (commonWords < other.words.length) {
            this.checkCapacity(other.words.length);
            int s = other.words.length;
            for (i = commonWords; s > i; ++i) {
                this.words[i] = other.words[i];
            }
        }
    }

    public void xor(BitVector other) {
        int i;
        int commonWords = Math.min(this.words.length, other.words.length);
        for (i = 0; commonWords > i; ++i) {
            int n = i;
            this.words[n] = this.words[n] ^ other.words[i];
        }
        if (commonWords < other.words.length) {
            this.checkCapacity(other.words.length);
            int s = other.words.length;
            for (i = commonWords; s > i; ++i) {
                this.words[i] = other.words[i];
            }
        }
    }

    public boolean intersects(BitVector other) {
        long[] bits = this.words;
        long[] otherBits = other.words;
        int s = Math.min(bits.length, otherBits.length);
        for (int i = 0; s > i; ++i) {
            if ((bits[i] & otherBits[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(BitVector other) {
        int bitsLength;
        int i;
        long[] bits = this.words;
        long[] otherBits = other.words;
        int otherBitsLength = otherBits.length;
        for (i = bitsLength = bits.length; i < otherBitsLength; ++i) {
            if (otherBits[i] == 0L) continue;
            return false;
        }
        int s = Math.min(bitsLength, otherBitsLength);
        for (i = 0; s > i; ++i) {
            if ((bits[i] & otherBits[i]) == otherBits[i]) continue;
            return false;
        }
        return true;
    }

    public int cardinality() {
        int count = 0;
        for (int i = 0; i < this.words.length; ++i) {
            count += Long.bitCount(this.words[i]);
        }
        return count;
    }

    public IntBag toIntBag(IntBag out) {
        if (this.isEmpty()) {
            out.setSize(0);
            return out;
        }
        int count = this.prepareBag(out, 1);
        int[] data = out.getData();
        int i = 0;
        int index = 0;
        while (count > index) {
            long bitset = this.words[i];
            int wordBits = i << 6;
            while (bitset != 0L) {
                long t = bitset & -bitset;
                data[index] = wordBits + Long.bitCount(t - 1L);
                bitset ^= t;
                ++index;
            }
            ++i;
        }
        return out;
    }

    public IntBag toIntBagIdCid(ComponentManager cm, IntBag out) {
        if (this.isEmpty()) {
            out.setSize(0);
            return out;
        }
        int count = this.prepareBag(out, 2);
        int[] data = out.getData();
        int i = 0;
        int index = 0;
        while (count > index) {
            long t;
            int wordBits = i << 6;
            for (long bitset = this.words[i]; bitset != 0L; bitset ^= t) {
                int id;
                t = bitset & -bitset;
                data[index] = id = wordBits + Long.bitCount(t - 1L);
                data[index + 1] = cm.getIdentity(id);
                index += 2;
            }
            ++i;
        }
        return out;
    }

    private int prepareBag(IntBag out, int elementsPerEntry) {
        int count = elementsPerEntry * this.cardinality();
        out.ensureCapacity(count);
        out.setSize(count);
        return count;
    }

    public int hashCode() {
        int word = this.length() >>> 6;
        int hash = 0;
        for (int i = 0; word >= i; ++i) {
            hash = 127 * hash + (int)(this.words[i] ^ this.words[i] >>> 32);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitVector other = (BitVector)obj;
        long[] otherBits = other.words;
        int commonWords = Math.min(this.words.length, otherBits.length);
        for (int i = 0; commonWords > i; ++i) {
            if (this.words[i] == otherBits[i]) continue;
            return false;
        }
        if (this.words.length == otherBits.length) {
            return true;
        }
        return this.length() == other.length();
    }

    public String toString() {
        int cardinality = this.cardinality();
        int end = Math.min(128, cardinality);
        StringBuilder sb = new StringBuilder();
        sb.append("BitVector[").append(cardinality);
        if (cardinality > 0) {
            sb.append(": {");
            int i = this.nextSetBit(0);
            for (int count = 0; end > count && i != -1; ++count) {
                if (count != 0) {
                    sb.append(", ");
                }
                sb.append(i);
                i = this.nextSetBit(i + 1);
            }
            if (cardinality > end) {
                sb.append(" ...");
            }
            sb.append("}");
        }
        sb.append("]");
        return sb.toString();
    }
}

