/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.utils;

import com.artemis.utils.BitVector;
import com.artemis.utils.IntBag;
import java.util.BitSet;

public final class ConverterUtil {
    private ConverterUtil() {
    }

    public static IntBag toIntBag(BitVector bs, IntBag out) {
        return bs.toIntBag(out);
    }

    public static IntBag toIntBag(BitSet bs, IntBag out) {
        if (bs.isEmpty()) {
            out.setSize(0);
            return out;
        }
        int size = bs.cardinality();
        out.setSize(size);
        out.ensureCapacity(size);
        int[] activesArray = out.getData();
        int id = -1;
        int s = size;
        for (int i = 0; s > i; ++i) {
            activesArray[i] = id = bs.nextSetBit(id + 1);
        }
        return out;
    }

    public static BitVector toBitVector(IntBag bag, BitVector out) {
        int[] data = bag.getData();
        int s = bag.size();
        for (int i = 0; s > i; ++i) {
            out.set(data[i]);
        }
        return out;
    }

    public static BitSet toBitSet(IntBag bag, BitSet out) {
        int[] data = bag.getData();
        int s = bag.size();
        for (int i = 0; s > i; ++i) {
            out.set(data[i]);
        }
        return out;
    }
}

