/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.utils;

import com.artemis.utils.ImmutableIntBag;
import java.util.Arrays;

public class IntBag
implements ImmutableIntBag {
    private int[] data;
    protected int size = 0;

    public IntBag() {
        this(64);
    }

    public IntBag(int capacity) {
        this.data = new int[capacity];
    }

    public boolean removeValue(int value) {
        int index = this.indexOf(value);
        if (index > -1) {
            this.removeIndex(index);
        }
        return index > -1;
    }

    @Deprecated
    public int remove(int index) {
        int e = this.data[index];
        this.data[index] = this.data[--this.size];
        this.data[this.size] = 0;
        return e;
    }

    public int removeIndex(int index) {
        int e = this.data[index];
        this.data[index] = this.data[--this.size];
        this.data[this.size] = 0;
        return e;
    }

    public int indexOf(int value) {
        for (int i = 0; this.size > i; ++i) {
            if (value != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(int value) {
        for (int i = 0; this.size > i; ++i) {
            if (value != this.data[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int get(int index) {
        if (index >= this.size) {
            String message = "tried accessing element " + index + "/" + this.size;
            throw new ArrayIndexOutOfBoundsException(message);
        }
        return this.data[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    public int getCapacity() {
        return this.data.length;
    }

    public boolean isIndexWithinBounds(int index) {
        return index < this.getCapacity();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(int value) {
        if (this.size == this.data.length) {
            this.grow(2 * this.data.length);
        }
        this.data[this.size++] = value;
    }

    public void addAll(IntBag other) {
        for (int i = 0; i < other.size(); ++i) {
            this.add(other.data[i]);
        }
    }

    public void set(int index, int value) {
        if (index >= this.data.length) {
            this.grow(Math.max(2 * this.data.length, index + 1));
        }
        this.size = Math.max(this.size, index + 1);
        this.data[index] = value;
    }

    private void grow(int newCapacity) {
        int[] oldData = this.data;
        this.data = new int[newCapacity];
        System.arraycopy(oldData, 0, this.data, 0, oldData.length);
    }

    public void ensureCapacity(int index) {
        if (index >= this.data.length) {
            this.grow(index + 1);
        }
    }

    public void clear() {
        Arrays.fill(this.data, 0, this.size, 0);
        this.size = 0;
    }

    public int[] getData() {
        return this.data;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntBag intBag = (IntBag)o;
        if (this.size != intBag.size()) {
            return false;
        }
        for (int i = 0; this.size > i; ++i) {
            if (this.data[i] == intBag.data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        int s = this.size;
        for (int i = 0; s > i; ++i) {
            hash = 127 * hash + this.data[i];
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IntBag(");
        for (int i = 0; this.size > i; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.data[i]);
        }
        sb.append(')');
        return sb.toString();
    }
}

