/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.utils;

import com.artemis.utils.IntBag;
import java.util.NoSuchElementException;

public class IntBagIterator {
    protected final IntBag intBag;
    protected int index;
    protected int indexEnd;
    protected State state;

    public IntBagIterator(IntBag intBag) {
        this.intBag = intBag;
        this.index = -1;
        int n = this.indexEnd = intBag != null ? intBag.size() : 0;
        assert (this.indexEnd >= 0);
        this.state = State.INIT;
    }

    public IntBagIterator(IntBag intBag, int indexBegin) {
        this.intBag = intBag;
        assert (indexBegin >= 0);
        this.index = indexBegin - 1;
        int n = this.indexEnd = intBag != null ? intBag.size() : 0;
        assert (this.indexEnd >= 0);
        this.state = State.INIT;
    }

    public IntBagIterator(IntBag intBag, int indexBegin, int size) {
        this.intBag = intBag;
        assert (indexBegin >= 0);
        this.index = indexBegin - 1;
        this.indexEnd = indexBegin + size;
        int allSize = intBag.size();
        int n = intBag != null ? (this.indexEnd < allSize ? this.indexEnd : allSize) : (this.indexEnd = 0);
        assert (this.indexEnd >= 0);
        this.state = State.INIT;
    }

    public int getCurrentIndex() {
        if (this.state == State.NEXT_CALLED && this.index < this.indexEnd && this.indexEnd <= this.intBag.size()) {
            return this.index;
        }
        throw new IllegalStateException(this.getErrorMessage(this.index));
    }

    public boolean hasNext() {
        return this.index + 1 < this.indexEnd && this.indexEnd <= this.intBag.size();
    }

    public int next() {
        int newIndex = this.index + 1;
        if (newIndex < this.indexEnd && this.indexEnd <= this.intBag.size()) {
            this.index = newIndex;
            this.state = State.NEXT_CALLED;
            return this.intBag.getData()[this.index];
        }
        throw new NoSuchElementException(this.getErrorMessage(newIndex));
    }

    public void remove() {
        if (this.state == State.NEXT_CALLED && this.index < this.indexEnd && this.indexEnd <= this.intBag.size()) {
            this.state = State.REMOVE_CALLED;
            this.intBag.removeIndex(this.index);
            --this.index;
            --this.indexEnd;
            assert (this.index < this.indexEnd);
        } else {
            throw new IllegalStateException(this.getErrorMessage(this.index));
        }
    }

    private String getErrorMessage(int indexVal) {
        String message = "Tried accessing element: " + indexVal + "/" + this.indexEnd + "/" + this.intBag.size() + "/" + this.state.name();
        return message;
    }

    protected static enum State {
        INIT,
        NEXT_CALLED,
        REMOVE_CALLED;

    }
}

