/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.utils;

import java.util.Arrays;

public class IntDeque {
    private int[] elements;
    private int beginIndex;
    protected int size = 0;

    public IntDeque() {
        this(64);
    }

    public IntDeque(int capacity) {
        this.elements = new int[capacity];
    }

    public boolean contains(int e) {
        for (int i = 0; this.size > i; ++i) {
            if (e != this.elements[this.index(i)]) continue;
            return true;
        }
        return false;
    }

    public int get(int index) {
        return this.elements[this.index(index)];
    }

    public int size() {
        return this.size;
    }

    public int getCapacity() {
        return this.elements.length;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(int e) {
        if (this.size == this.elements.length) {
            this.grow(this.elements.length * 7 / 4 + 1);
        }
        this.elements[this.index((int)this.size++)] = e;
    }

    private int index(int relativeIndex) {
        return (this.beginIndex + relativeIndex) % this.elements.length;
    }

    public void set(int index, int e) {
        if (index >= this.elements.length) {
            this.grow(index * 7 / 4 + 1);
        }
        this.size = Math.max(this.size, index + 1);
        this.elements[this.index((int)index)] = e;
    }

    private void grow(int newCapacity) {
        int[] newElements = new int[newCapacity];
        for (int i = 0; i < this.size; ++i) {
            newElements[i] = this.get(i);
        }
        this.elements = newElements;
        this.beginIndex = 0;
    }

    public void ensureCapacity(int index) {
        if (index >= this.elements.length) {
            this.grow(index);
        }
    }

    public void clear() {
        Arrays.fill(this.elements, 0, this.size, 0);
        this.size = 0;
        this.beginIndex = 0;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int popLast() {
        this.assertNotEmpty();
        int index = this.index(--this.size);
        int value = this.elements[index];
        return value;
    }

    public int popFirst() {
        this.assertNotEmpty();
        int value = this.elements[this.beginIndex];
        this.beginIndex = (this.beginIndex + 1) % this.elements.length;
        --this.size;
        return value;
    }

    private void assertNotEmpty() {
        if (this.size == 0) {
            throw new RuntimeException("Deque is empty.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntDeque other = (IntDeque)o;
        if (this.size != other.size) {
            return false;
        }
        for (int i = 0; this.size > i; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        int s = this.size;
        for (int i = 0; s > i; ++i) {
            hash = 127 * hash + this.elements[i];
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IntDeque(");
        for (int i = 0; this.size > i; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.elements[this.index(i)]);
        }
        sb.append(')');
        return sb.toString();
    }
}

