/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.utils;

import java.util.Arrays;

public class ShortBag {
    private short[] data;
    protected int size = 0;

    public ShortBag() {
        this(64);
    }

    public ShortBag(int capacity) {
        this.data = new short[capacity];
    }

    public boolean removeValue(short value) {
        int index = this.indexOf(value);
        if (index > -1) {
            this.remove(index);
        }
        return index > -1;
    }

    public int remove(int index) {
        short e = this.data[index];
        this.data[index] = this.data[--this.size];
        this.data[this.size] = 0;
        return e;
    }

    public int indexOf(short value) {
        for (int i = 0; this.size > i; ++i) {
            if (value != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(short value) {
        for (int i = 0; this.size > i; ++i) {
            if (value != this.data[i]) continue;
            return true;
        }
        return false;
    }

    public short get(int index) {
        return this.data[index];
    }

    public int size() {
        return this.size;
    }

    public int getCapacity() {
        return this.data.length;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(short value) {
        if (this.size == this.data.length) {
            this.grow();
        }
        this.data[this.size++] = value;
    }

    public void addAll(ShortBag other) {
        for (int i = 0; i < other.size(); ++i) {
            this.add(other.get(i));
        }
    }

    public void unsafeSet(int index, short value) {
        this.data[index] = value;
    }

    public void set(int index, short value) {
        if (index >= this.data.length) {
            this.grow(index * 7 / 4 + 1);
        }
        this.size = Math.max(this.size, index + 1);
        this.data[index] = value;
    }

    private void grow() {
        int newCapacity = this.data.length * 7 / 4 + 1;
        this.grow(newCapacity);
    }

    private void grow(int newCapacity) {
        short[] oldData = this.data;
        this.data = new short[newCapacity];
        System.arraycopy(oldData, 0, this.data, 0, oldData.length);
    }

    public void ensureCapacity(int index) {
        if (index >= this.data.length) {
            this.grow(index + 1);
        }
    }

    public void clear() {
        int s = this.size;
        for (int i = 0; s > i; ++i) {
            this.data[i] = 0;
        }
        this.size = 0;
    }

    public short[] getData() {
        return this.data;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortBag intBag = (ShortBag)o;
        return this.size == intBag.size() && Arrays.equals(this.data, intBag.data);
    }

    public int hashCode() {
        int hash = 0;
        int s = this.size;
        for (int i = 0; s > i; ++i) {
            hash = 127 * hash + this.data[i];
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IntBag(");
        for (int i = 0; this.size > i; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.data[i]);
        }
        sb.append(')');
        return sb.toString();
    }
}

